/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.app.service.DWService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.AbstractVersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.scan.metadata.CommonApiMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReaderFactory;

public class DWRestfulApiCandidate
extends AbstractVersionApiCandidate {
    private static Log log = LogFactory.getLog(DWRestfulApiCandidate.class);
    private static String REQUEST_PATH_PREFIX = "/restful/service/";
    MethodsMetadataReaderFactory methodsMetadataReaderFactory = new MethodsMetadataReaderFactory();

    @Override
    public List<ApiMetadata> resolverPathRegex(MetadataReader metadataReader, String rootPath) {
        ArrayList<ApiMetadata> apiMetadataList;
        block7: {
            String[] resourcePathArray;
            block8: {
                String resourceRegexStr;
                apiMetadataList = new ArrayList<ApiMetadata>();
                if (!metadataReader.getClassMetadata().isInterface() || !Arrays.stream(metadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) break block7;
                String[] classNameSplit = metadataReader.getClassMetadata().getClassName().split("\\.");
                String intetfaceSimpleName = classNameSplit[classNameSplit.length - 1];
                if (intetfaceSimpleName.matches(resourceRegexStr = "I[^a-z]\\S{1,}Service")) {
                    String[] resouceName = intetfaceSimpleName.substring(1, intetfaceSimpleName.length() - 7);
                    resourcePathArray = new String[]{intetfaceSimpleName, resouceName, resouceName.substring(0, 1).toLowerCase() + resouceName.substring(1)};
                } else {
                    resourcePathArray = new String[]{intetfaceSimpleName};
                }
                if (!metadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName())) break block8;
                for (String resouceNam : resourcePathArray) {
                    CommonApiMetadata commonApiMetadata = new CommonApiMetadata(REQUEST_PATH_PREFIX + rootPath + "/" + resouceNam + "/*");
                    apiMetadataList.add(commonApiMetadata);
                }
                break block7;
            }
            MethodsMetadataReader methodsMetadataReader = null;
            try {
                methodsMetadataReader = this.getMethodsMetadataReaderFactory().getMetadataReader(metadataReader.getResource());
            }
            catch (IOException e) {
                log.error((Object)("read classMethodMetadata failure  module:" + rootPath + "className:" + metadataReader.getClassMetadata().getClassName()), (Throwable)e);
            }
            if (null == methodsMetadataReader) break block7;
            Set methodMetadataSet = methodsMetadataReader.getMethodsMetadata().getMethods();
            for (MethodMetadata methodMetadata : methodMetadataSet) {
                for (String resouceNam : resourcePathArray) {
                    apiMetadataList.add(new CommonApiMetadata(REQUEST_PATH_PREFIX + rootPath + "/" + resouceNam + "/" + methodMetadata.getMethodName(), methodMetadata.isAnnotated(DWVersionable.class.getName())));
                }
            }
        }
        return apiMetadataList;
    }

    MethodsMetadataReaderFactory getMethodsMetadataReaderFactory() {
        return this.methodsMetadataReaderFactory;
    }
}

