/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher;

import com.digiwin.loadbalance.matcher.DWMatcher;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.core.annotation.Order;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

@Order(value=2147482647)
public class EAICallBackMatcher
implements DWMatcher {
    private static final String EAIPATH_PATTERN_CALLBACK = "/eai/**/callback";
    AntPathMatcher antPathMatcher = new AntPathMatcher();

    private boolean pathMatche(String pattern, String path) {
        return this.antPathMatcher.match(pattern, path);
    }

    @Override
    public String prefix() {
        return "EAI";
    }

    @Override
    public boolean canApply(HttpUriRequest request) {
        Header callbackHeader = request.getFirstHeader("digi-callback-callback");
        return null != callbackHeader && StringUtils.hasText((String)callbackHeader.getValue()) && this.pathMatche(EAIPATH_PATTERN_CALLBACK, request.getURI().getPath());
    }

    @Override
    public String getCacheKey(HttpUriRequest request) {
        Header callbackHeader = request.getLastHeader("digi-callback-callback");
        return callbackHeader.getValue();
    }

    @Override
    public boolean match(String pattern, HttpUriRequest request) {
        String apiId = this.prefix() + "|" + this.getCacheKey(request);
        return apiId.equals(pattern);
    }
}

