/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.loadbalance.region.RegionSwitch;
import com.digiwin.loadbalance.region.RegionSwitchEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class DefaultRegionSwitch
implements RegionSwitch {
    ApplicationContext applicationContext;
    private final String Active_Region_Sufix = "ar";
    private final String Tenant_Region_Sufix = "tr";
    private String serviceName;
    private Map<String, String> imageActiveRegionMap = new ConcurrentHashMap<String, String>();
    private Map<String, Config> regionTenanConfigMap = new ConcurrentHashMap<String, Config>();
    private Map<String, Map<String, List<String>>> regionConfigFileMap = new ConcurrentHashMap<String, Map<String, List<String>>>();

    public DefaultRegionSwitch(String serviceName, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.serviceName = serviceName;
        String regionNameSpace = serviceName + "_" + "ar";
        Config config = ConfigService.getConfig((String)regionNameSpace);
        this.fillImageRegion(config);
        config.addChangeListener(changeEvent -> {
            applicationContext.publishEvent((ApplicationEvent)new RegionSwitchEvent(this, serviceName));
            this.imageActiveRegionMap.clear();
            this.regionTenanConfigMap.clear();
            this.fillImageRegion(config);
        });
    }

    public void fillImageRegion(Config config) {
        config.getPropertyNames().stream().forEach(serviceImage -> {
            String tenantRegionConfigName = this.getTenantRegionConfigName(this.serviceName, (String)serviceImage);
            Config tenantRegionConfig = this.regionTenanConfigMap.get(tenantRegionConfigName);
            if (Objects.isNull(tenantRegionConfig)) {
                tenantRegionConfig = ConfigService.getConfig((String)tenantRegionConfigName);
                if (Objects.isNull(tenantRegionConfig)) {
                    return;
                }
                this.regionTenanConfigMap.put(tenantRegionConfigName, tenantRegionConfig);
                Config finalTenantRegionConfig = tenantRegionConfig;
                tenantRegionConfig.addChangeListener(changeEvent -> {
                    this.applicationContext.publishEvent((ApplicationEvent)new RegionSwitchEvent(this, this.serviceName));
                    this.regionConfigFileMap.remove(serviceImage);
                    this.fillTenantConfig(finalTenantRegionConfig, (String)serviceImage, config.getProperty(serviceImage, ""));
                });
            }
            this.fillTenantConfig(tenantRegionConfig, (String)serviceImage, config.getProperty(serviceImage, ""));
        });
    }

    private void fillTenantConfig(Config tenantRegionConfig, String serviceImage, String atciveRegion) {
        if (Objects.isNull(tenantRegionConfig) || tenantRegionConfig.getPropertyNames().size() != 2) {
            return;
        }
        for (String region : tenantRegionConfig.getPropertyNames()) {
            Map regionTenantMap = this.regionConfigFileMap.getOrDefault(serviceImage, new ConcurrentHashMap());
            String tenantIds = tenantRegionConfig.getProperty(region, "");
            if (StringUtils.isNotBlank((CharSequence)tenantIds)) {
                regionTenantMap.put(region, Arrays.asList(tenantIds.split(",")));
            }
            this.regionConfigFileMap.put(serviceImage, regionTenantMap);
        }
        this.imageActiveRegionMap.put(serviceImage, atciveRegion);
    }

    public String getTenantRegionConfigName(String serviceName, String serviceImage) {
        return serviceName + "_" + serviceImage + "_" + "tr";
    }

    @Override
    public Optional<Predicate<? super ServiceInstance>> getRegionPredicate(String tenantId) {
        return Optional.of(seviceInstance -> {
            String instanceIamge = (String)seviceInstance.getMetadata().get("APPIMAGENAME");
            String instanceRegion = (String)seviceInstance.getMetadata().get("STATEMODE");
            if (StringUtils.isBlank((CharSequence)instanceIamge)) {
                return true;
            }
            AtomicReference<String> targetRegion = new AtomicReference<String>();
            AtomicReference<String> targetImage = new AtomicReference<String>();
            block0: for (Map.Entry<String, Map<String, List<String>>> entry : this.regionConfigFileMap.entrySet()) {
                String imageName = entry.getKey();
                String entryActiveRegion = this.imageActiveRegionMap.get(imageName);
                for (Map.Entry<String, List<String>> regionTenantIdEntry : entry.getValue().entrySet()) {
                    if (entryActiveRegion.equals(regionTenantIdEntry.getKey()) || !regionTenantIdEntry.getValue().contains(tenantId)) continue;
                    targetRegion.set(regionTenantIdEntry.getKey());
                    targetImage.set(imageName);
                    break block0;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)targetRegion.get())) && StringUtils.isNotBlank((CharSequence)((CharSequence)targetImage.get()))) {
                return ((String)targetRegion.get()).equals(instanceRegion) && ((String)targetImage.get()).equals(instanceIamge);
            }
            String activeRegion = this.imageActiveRegionMap.get(instanceIamge);
            return StringUtils.equals((CharSequence)instanceRegion, (CharSequence)activeRegion);
        });
    }
}

