/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.digiwin.loadbalance.client.autoconfigure.DWClientLoadBalancerAutoConfiguration;
import com.digiwin.loadbalance.client.httpclient.DWDefaultHttpLoadbalanceRoute;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.esp.DWEAIPropertiesBean;
import com.digiwin.loadbalance.esp.ESPExecutorPoolProperties;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.event.RegestionApplicationListener;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={DWClientLoadBalancerAutoConfiguration.class})
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
public class DWLoadBalancerAutoConfiguration {
    private static Log log = LogFactory.getLog(DWLoadBalancerAutoConfiguration.class);

    @Bean
    DWDiscoveryProperties dwDiscoveryProperties(Environment environment, DWCommonScanner dwCommonScanner) throws Exception {
        DWDiscoveryProperties dwDiscoveryProperties = new DWDiscoveryProperties();
        dwDiscoveryProperties.setApiSet(dwCommonScanner.scan());
        return dwDiscoveryProperties;
    }

    @Bean
    public NacosServerListWatcher nacosServerListWatcher(Environment environment, NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosServerListWatcher(nacosServiceManager, nacosDiscoveryProperties);
    }

    @Bean
    public NacosRegistrationCustomizer nacosRegistrationCustomizer(DWDiscoveryProperties dwDiscoveryProperties, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider, Environment environment) {
        log.debug((Object)("DWDiscoveryProperties:" + dwDiscoveryProperties + " Environment properties name:dwallVersionAble  , value:" + environment.getProperty("dwallVersionAble")));
        return nacosRegistration -> {
            boolean defaultVersionFlag = "default".equals(dwDiscoveryProperties.getAppVersion());
            Map metadata = nacosRegistration.getMetadata();
            this.resetDiscoverProperty(nacosRegistration.getNacosDiscoveryProperties(), dwDiscoveryProperties);
            boolean allVersionAble = "true".equalsIgnoreCase(dwDiscoveryProperties.getAllVersionAble());
            Iterator<ApiMetadata> apiMetadataIterator = dwDiscoveryProperties.getApiSet().iterator();
            int versionAbleIndex = 0;
            int apiIndex = 0;
            while (apiMetadataIterator.hasNext()) {
                ApiMetadata apiMetadata = apiMetadataIterator.next();
                metadata.put("api-info." + apiIndex + "." + "api-id", apiMetadata.getInstanceMatchId());
                ++apiIndex;
                if (defaultVersionFlag || !apiMetadata.getVersionAble() && !allVersionAble) continue;
                metadata.put("dw-version-info." + versionAbleIndex + "." + "path", apiMetadata.getVersionAbleId());
                ++versionAbleIndex;
            }
            String imageName = System.getenv("APPIMAGENAME");
            String region = System.getenv("STATEMODE");
            if (StringUtils.isNotBlank((CharSequence)imageName) && StringUtils.isNotBlank((CharSequence)region)) {
                metadata.put("APPIMAGENAME", imageName);
                metadata.put("STATEMODE", region);
            }
            this.registerEAI(metadata, eaiPropertiesProvider);
            metadata.put("version", StringUtils.isNotBlank((CharSequence)dwDiscoveryProperties.getAppVersion()) ? dwDiscoveryProperties.getAppVersion() : "default");
            metadata.put("describe", dwDiscoveryProperties.getDwappDescribe());
            String loadbalanceVersion = DWLoadBalancerAutoConfiguration.class.getPackage().getImplementationVersion();
            metadata.put("loadbalance_version", StringUtils.isNotBlank((CharSequence)loadbalanceVersion) ? loadbalanceVersion : "unknown");
        };
    }

    private void resetDiscoverProperty(NacosDiscoveryProperties nacosDiscoveryProperties, DWDiscoveryProperties dwDiscoveryProperties) {
        String serviceName = Objects.nonNull(dwDiscoveryProperties.getAppid()) ? dwDiscoveryProperties.getAppid() : dwDiscoveryProperties.getSpringApplicationName();
        nacosDiscoveryProperties.setService(serviceName.split("_")[0]);
        if (StringUtils.isNumeric((CharSequence)dwDiscoveryProperties.getPort())) {
            nacosDiscoveryProperties.setPort(Integer.valueOf(dwDiscoveryProperties.getPort()).intValue());
        }
        if (StringUtils.isNotBlank((CharSequence)dwDiscoveryProperties.getIp())) {
            nacosDiscoveryProperties.setIp(dwDiscoveryProperties.getIp());
        }
        if (StringUtils.isNumeric((CharSequence)dwDiscoveryProperties.getWatchDelay())) {
            nacosDiscoveryProperties.setWatchDelay(Long.valueOf(dwDiscoveryProperties.getWatchDelay()).longValue());
        }
        nacosDiscoveryProperties.setUsername(dwDiscoveryProperties.getUsername());
        nacosDiscoveryProperties.setPassword(dwDiscoveryProperties.getPassword());
        nacosDiscoveryProperties.setClusterName(dwDiscoveryProperties.getClusterName());
        nacosDiscoveryProperties.setNamespace(dwDiscoveryProperties.getNamespace());
        nacosDiscoveryProperties.setGroup(dwDiscoveryProperties.getGroup());
    }

    public void registerEAI(Map<String, String> metadata, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider) {
        DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
        if (null != eaiProperties) {
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
                metadata.put("eai.hostRetryInterval", eaiProperties.getHostRetryInterval());
            }
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
                metadata.put("eai.hostRetryTimes", eaiProperties.getHostRetryTimes());
            }
            if (StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServicePath())) {
                metadata.put("eai.restfulPath", eaiProperties.getRestfulServicePath());
            }
            if (StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServiceCallbackPath())) {
                metadata.put("eai.callbackPath", eaiProperties.getRestfulServiceCallbackPath());
            }
        }
    }

    @Bean
    RegestionApplicationListener regestionApplicationListener(DWDiscoveryProperties dwDiscoveryProperties, NamingProxy namingProxy) {
        return new RegestionApplicationListener(dwDiscoveryProperties, namingProxy);
    }

    @Bean
    NamingProxy namingProxy(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) throws NoSuchFieldException, IllegalAccessException {
        NamingService namingService = nacosServiceManager.getNamingService(nacosDiscoveryProperties.getNacosProperties());
        Field serverProxyField = namingService.getClass().getDeclaredField("serverProxy");
        serverProxyField.setAccessible(true);
        NamingProxy namingProxy = (NamingProxy)serverProxyField.get(namingService);
        return namingProxy;
    }

    @Bean
    ESPExecutorPoolProperties espExecutorPoolProperties() {
        return new ESPExecutorPoolProperties();
    }

    @Bean
    public ESPLoadBalanceUtil init(DiscoveryClient discoveryClient, @Qualifier(value="dwDefaultHttpLoadbalanceRoute") DWDefaultHttpLoadbalanceRoute dwRoutePlanner, NacosServerListWatcher nacosServerListWatcher, Environment environment, NacosDiscoveryProperties nacosDiscoveryProperties, ESPExecutorPoolProperties espExecutorPoolProperties, NamingProxy namingProxy, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider) {
        ESPLoadBalanceUtil espLoadBalanceUtil = new ESPLoadBalanceUtil();
        String dwloadBalanceEnable = environment.getProperty("dwloadBalanceEnable");
        String esploadBalanceEnable = environment.getProperty("esp.loadbalance.enable");
        if ("true".equalsIgnoreCase(dwloadBalanceEnable) && !"false".equalsIgnoreCase(esploadBalanceEnable)) {
            ESPLoadBalanceUtil.setLoadBalanceEnable(true);
        } else {
            ESPLoadBalanceUtil.setLoadBalanceEnable(false);
        }
        ESPLoadBalanceUtil.setDiscoveryClient(discoveryClient);
        ESPLoadBalanceUtil.setDwRoutePlanner(dwRoutePlanner);
        ESPLoadBalanceUtil.setNacosServerListWatcher(nacosServerListWatcher);
        ESPLoadBalanceUtil.setDiscoveryProperties(nacosDiscoveryProperties);
        ESPLoadBalanceUtil.setEspExecutorPoolProperties(espExecutorPoolProperties);
        ESPLoadBalanceUtil.setNamingProxy(namingProxy);
        DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
        if (null != eaiProperties) {
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
                ESPLoadBalanceUtil.setEaiHostRetryInterval(Integer.valueOf(eaiProperties.getHostRetryInterval()));
            }
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
                ESPLoadBalanceUtil.setEaiHostRetryTimes(Integer.valueOf(eaiProperties.getHostRetryTimes()));
            }
            ESPLoadBalanceUtil.setEaiRestfulPath(eaiProperties.getRestfulServicePath());
            ESPLoadBalanceUtil.setEaiCallbackPath(eaiProperties.getRestfulServiceCallbackPath());
        }
        return espLoadBalanceUtil;
    }
}

