/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate.v2;

import com.digiwin.app.service.DWService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.v2.AbstractApiCandidateV2;
import com.digiwin.loadbalance.scan.metadata.compress.DWCommonApiMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReaderFactory;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DWRestfulApiCandidateV2
extends AbstractApiCandidateV2<DWCommonApiMetadata> {
    private static Log log = LogFactory.getLog(DWRestfulApiCandidateV2.class);
    MethodsMetadataReaderFactory methodsMetadataReaderFactory = new MethodsMetadataReaderFactory();

    @Override
    public List<DWCommonApiMetadata> resolverPathRegex(MetadataReader classMetadataReader, String rootPath) {
        ArrayList<DWCommonApiMetadata> apiMetadataList = new ArrayList<DWCommonApiMetadata>();
        if (classMetadataReader.getClassMetadata().isInterface() && Arrays.stream(classMetadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) {
            String[] classNameSplit = classMetadataReader.getClassMetadata().getClassName().split("\\.");
            String intetfaceSimpleName = classNameSplit[classNameSplit.length - 1];
            boolean classVersionAble = classMetadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName());
            MethodsMetadataReader methodsMetadataReader = null;
            try {
                methodsMetadataReader = this.getMethodsMetadataReaderFactory().getMetadataReader(classMetadataReader.getResource());
            }
            catch (Exception e) {
                log.error((Object)("read classMethodMetadata failure  module:" + rootPath + "className:" + classMetadataReader.getClassMetadata().getClassName()), (Throwable)e);
            }
            if (null != methodsMetadataReader) {
                methodsMetadataReader.getMethodsMetadata().getMethods();
                for (MethodMetadata methodMetadata : methodsMetadataReader.getMethodsMetadata().getMethods()) {
                    int[] tags = this.getTags(null, this.appVersionAble() && (this.allVersionAble() || classVersionAble || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                    UriComponents uriComponents = UriComponentsBuilder.newInstance().path("/").path(rootPath).path("/").path(intetfaceSimpleName).path("/").path(methodMetadata.getMethodName()).build();
                    apiMetadataList.add(new DWCommonApiMetadata(uriComponents.getPath(), tags));
                }
            }
        }
        return apiMetadataList;
    }

    @Override
    public int[] processBaseTages(int[] baseTags) {
        if (ArrayUtils.isEmpty((int[])baseTags)) {
            throw new IllegalArgumentException("tags must not be empty");
        }
        int baseTag = baseTags[0];
        baseTags[0] = ++baseTag;
        return baseTags;
    }

    MethodsMetadataReaderFactory getMethodsMetadataReaderFactory() {
        return this.methodsMetadataReaderFactory;
    }
}

