/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.exception.DWInstanceServiceNotFoundException;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.util.CollectionUtils;

public class DWDefaultHttpLoadbalanceRoute
implements HttpRoutePlanner {
    private static Log log = LogFactory.getLog(DWDefaultHttpLoadbalanceRoute.class);
    @Autowired
    TenantIdService tenantIdService;
    @Autowired
    DiscoveryClient discoveryClient;
    @Autowired
    DWDiscoveryProperties dwDiscoveryProperties;
    private final DWLoadBalancerClientFactory loadBalancerClientFactory;

    public DWDefaultHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpContext context) throws HttpException {
        log.debug((Object)("httpHost:" + httpHost));
        if (Objects.nonNull(DWLoadBalanceUtils.getLoadBalanceFlag()) && !DWLoadBalanceUtils.getLoadBalanceFlag().booleanValue()) {
            log.info((Object)"DWDefaultHttpLoadbalanceRoute LoadBalanceFlag false  ");
            DWLoadBalanceUtils.resetFlag();
            DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)false);
            return new HttpRoute(httpHost);
        }
        DWLoadBalanceUtils.resetFlag();
        DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)true);
        context.setAttribute("dwloadbalance.service.name", (Object)httpHost.getHostName());
        if (CollectionUtils.isEmpty((Collection)this.discoveryClient.getInstances(httpHost.getHostName()))) {
            log.error((Object)("no service instance named  " + httpHost.getHostName()));
            throw new DWInstanceServiceNotFoundException(HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_MESSAGE + httpHost.getHostName());
        }
        HttpRequestWrapper wrapRequest = HttpRequestWrapper.wrap((HttpRequest)request);
        DWLoadBalanceRequestUtils.setRequest((HttpUriRequest)wrapRequest);
        String tenantId = null;
        try {
            tenantId = this.getTenantId(wrapRequest);
            DWLoadBalanceRequestUtils.setTenantId(tenantId);
        }
        catch (Exception e) {
            log.error((Object)("get TenantId fail tenantId: " + tenantId), (Throwable)e);
            throw new HttpException("get TenantId fail", (Throwable)e);
        }
        ServiceInstanceChooser loadBalancer = this.loadBalancerClientFactory.getInstance(httpHost.getHostName());
        ServiceInstance server = loadBalancer.choose(httpHost.getHostName());
        if (null == server) {
            log.error((Object)("find service fail host:" + httpHost + ", url:" + wrapRequest.getURI() + ",tenantId:" + tenantId));
            throw new HttpException("Service not found");
        }
        HttpHost tragetHost = new HttpHost(server.getHost(), server.getPort());
        log.info((Object)("target host:" + tragetHost + " for: " + httpHost));
        return new HttpRoute(tragetHost);
    }

    private String getTenantId(HttpRequestWrapper wrapRequest) throws Exception {
        String tenantId = null;
        tenantId = this.getRouteKey(wrapRequest);
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            log.info((Object)("loadbalanceRoute routeKey:" + tenantId + ",url:" + wrapRequest.getURI()));
            return tenantId;
        }
        String token = this.getToken(wrapRequest);
        log.info((Object)("loadbalanceRoute token:" + token + ",url:" + wrapRequest.getURI()));
        tenantId = this.tenantIdService.getTenantId(token);
        return tenantId;
    }

    private String getRouteKey(HttpRequestWrapper wrapRequest) {
        return this.getPriorityRequestHeader(wrapRequest, this.dwDiscoveryProperties.getRouteKeyNamesList());
    }

    private String getToken(HttpRequestWrapper wrapRequest) {
        return this.getPriorityRequestHeader(wrapRequest, this.dwDiscoveryProperties.getTokenNamesList());
    }

    private String getPriorityRequestHeader(HttpRequestWrapper wrapRequest, List<String> names) {
        for (String name : names) {
            Header header = wrapRequest.getFirstHeader(name);
            if (null == header) continue;
            return header.getValue();
        }
        return null;
    }
}

