/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.autoconfigure;

import com.digiwin.loadbalance.client.httpclient.DWAttemptHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultMainExecWrapperFactory;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapperFactory;
import com.digiwin.loadbalance.client.httpclient.reroute.DWAttemptReRoutePlanner;
import com.digiwin.loadbalance.client.httpclient.reroute.DWDefaultReRoutePlanner;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.UrlPathMatcher;
import com.digiwin.loadbalance.matcher.delegate.DWMatcherDelegate;
import com.digiwin.loadbalance.matcher.delegate.UrlPathMatcherDelegate;
import com.digiwin.loadbalance.matcher.v2.DWMatcherV2;
import com.digiwin.loadbalance.matcher.v2.UrlPathMatcherV2;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
public class DWClientLoadBalancerAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={HttpClient.class})
    public DWLoadBalancerClientFactory loadBalancerClientFactory() {
        return new DWLoadBalancerClientFactory();
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwDefaultHttpLoadbalanceRoute"})
    HttpRoutePlanner dwHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        return new DWDefaultHttpLoadbalanceRoute(loadBalancerClientFactory);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwAttemptHttpLoadbalanceRoute"})
    @ConditionalOnProperty(name={"dwhttpClient.loadbalance.mode"}, havingValue="auto")
    HttpRoutePlanner dwAttemptHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        return new DWAttemptHttpLoadbalanceRoute(loadBalancerClientFactory);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwDefaultReRoutePlanner"})
    HttpRoutePlanner dwDefaultReRoutePlanner(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        return new DWDefaultReRoutePlanner(loadBalancerClientFactory);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwAttemptReRoutePlanner"})
    @ConditionalOnProperty(name={"dwhttpClient.loadbalance.mode"}, havingValue="auto")
    HttpRoutePlanner dwWAttemptReRoutePlanner(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        return new DWAttemptReRoutePlanner(loadBalancerClientFactory);
    }

    @Bean
    DWMatcher urlPathMatcher() {
        return new UrlPathMatcher();
    }

    @Bean
    DWMatcherV2 urlPathMatcherV2() {
        return new UrlPathMatcherV2();
    }

    @Bean
    @DependsOn(value={"urlPathMatcherV2", "urlPathMatcher"})
    DWMatcherDelegate urlPathMatcherDelegate() {
        return new UrlPathMatcherDelegate();
    }

    @Bean(value={"dwDefaultMainExecWrapperFactory"})
    @ConditionalOnClass(value={HttpClient.class})
    DWMainExecWrapperFactory dwDefaultMainExecWrapperFactory(DiscoveryClient discoveryClient, DWLoadBalancerClientFactory loadBalancerClientFactory, Environment environment) {
        return new DWDefaultMainExecWrapperFactory(discoveryClient, loadBalancerClientFactory, !"auto".equalsIgnoreCase(environment.getProperty("dwhttpClient.loadbalance.mode")));
    }
}

