/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.loadbalance.extend.spi.DWRouteProcess;
import com.digiwin.loadbalance.extend.spi.DWRouteProcessServiceLocated;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;

public abstract class BaseHttpRoutePlanner
implements HttpRoutePlanner {
    public static final AtomicBoolean inited = new AtomicBoolean(false);

    public BaseHttpRoutePlanner() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (inited.get()) return;
        Class<BaseHttpRoutePlanner> clazz = BaseHttpRoutePlanner.class;
        synchronized (BaseHttpRoutePlanner.class) {
            inited.compareAndSet(false, true);
            this.loadExtendProcess();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void loadExtendProcess() {
        DWRouteProcessServiceLocated.load();
    }

    public HttpHost beforeRoute(HttpHost httpHost, HttpRequest request) {
        if (null == httpHost || null == request) {
            throw new IllegalArgumentException("httphost and request must not be null");
        }
        DWRouteProcess extendProcesse = DWRouteProcessServiceLocated.getPriorityProcess();
        if (null == extendProcesse) {
            return httpHost;
        }
        HttpHost processedHost = extendProcesse.beforeRoute(httpHost, request);
        if (null == processedHost) {
            return httpHost;
        }
        return processedHost;
    }
}

