/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.loadbalance.region.RegionSwitch;
import com.digiwin.loadbalance.util.DWInstanceUtils;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationContext;

public class DefaultRegionSwitch
implements RegionSwitch {
    private static Log log = LogFactory.getLog(DefaultRegionSwitch.class);
    ApplicationContext applicationContext;
    private String serviceName;

    public DefaultRegionSwitch(String serviceName, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.serviceName = serviceName;
    }

    @Override
    public Optional<Predicate<? super ServiceInstance>> getRegionPredicate(String tenantId) {
        return Optional.of(seviceInstance -> {
            String instanceIamge = (String)seviceInstance.getMetadata().get("APPIMAGENAME");
            String instanceRegion = (String)seviceInstance.getMetadata().get("STATEMODE");
            if (StringUtils.isBlank((CharSequence)instanceIamge)) {
                return true;
            }
            String target_region = null;
            String arNameSpace = this.serviceName + "_" + "ar";
            Config arConfig = ConfigService.getConfig((String)arNameSpace);
            String atviceRegion = arConfig.getProperty(instanceIamge, "");
            String preRegion = DWInstanceUtils.getPreRegion(atviceRegion);
            String trNameSpace = this.serviceName + "_" + instanceIamge + "_" + "tr";
            Config trConfig = ConfigService.getConfig((String)trNameSpace);
            if (StringUtils.isBlank((CharSequence)preRegion) || trConfig.getPropertyNames().size() != 2) {
                return false;
            }
            String preTenantList = trConfig.getProperty(preRegion, "");
            target_region = StringUtils.isNotBlank((CharSequence)tenantId) && Arrays.stream(preTenantList.split(",")).filter(configTenantId -> configTenantId.equals(tenantId)).findAny().isPresent() ? preRegion : atviceRegion;
            return instanceRegion.equals(target_region);
        });
    }
}

