/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.loadbalance.scan.candidate.DWAbstractResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.resource.simplified.DWSimplifiedGroupLocationInfo;
import com.digiwin.resource.simplified.utils.DWSimplifiedResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.StringUtils;

public class DWGroupResourceHelper
extends DWAbstractResourceHelper {
    private Log log = LogFactory.getLog(DWGroupResourceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DWTargetResource> getDWTargetResource(Environment environment) {
        ArrayList groupResourceList = new ArrayList();
        String[] classPaths = System.getProperty("java.class.path").split(File.pathSeparator);
        this.log.info((Object)("load classpath:" + System.getProperty("java.class.path")));
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String path : classPaths) {
            if (path.endsWith(".jar")) {
                JarFile jarFile = null;
                try {
                    Attributes mainAttributes;
                    String manifestClassPath;
                    jarFile = new JarFile(path);
                    Manifest manifest = jarFile.getManifest();
                    if (null != manifest && !StringUtils.isEmpty((Object)(manifestClassPath = (mainAttributes = manifest.getMainAttributes()).getValue("Class-Path")))) {
                        String[] manifestClassPathArray;
                        for (String manifestPath : manifestClassPathArray = manifestClassPath.split(" ")) {
                            URL url2 = new URL(manifestPath);
                            urlList.add(url2);
                        }
                    }
                }
                catch (IOException e) {
                    this.log.error((Object)"read manifest file fail {} ", (Throwable)e);
                }
                finally {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        this.log.error((Object)"DWGroupResourceHelper jarFile close faile{} ", (Throwable)e);
                    }
                }
            }
            try {
                URL url3 = new URL("file", "", -1, path);
                urlList.add(url3);
            }
            catch (MalformedURLException e) {
                this.log.error((Object)("classpath  Malformed classpath: " + path), (Throwable)e);
            }
        }
        urlList.stream().forEach(url -> {
            DWSimplifiedGroupLocationInfo groupInfo = null;
            UrlResource urlResource = new UrlResource(url);
            try {
                if (urlResource.exists()) {
                    groupInfo = DWSimplifiedResourceUtils.getGroupName((File)urlResource.getFile());
                }
            }
            catch (IOException e) {
                this.log.error((Object)("get groupInfo fail url:" + url.toString()), (Throwable)e);
            }
            Resource[] resources = new Resource[]{};
            try {
                resources = this.getResources(url.toString());
            }
            catch (IOException e) {
                this.log.error((Object)("get group resources fail url:" + url.toString()), (Throwable)e);
            }
            groupResourceList.add(new GroupResource(groupInfo, resources));
        });
        return groupResourceList.stream().sorted((o1, o2) -> {
            int o1Layer = o1.getGroupInfo() == null || !StringUtils.hasText((String)o1.getGroupInfo().getName()) ? Integer.MIN_VALUE : o1.getGroupInfo().getBusinessLayer();
            int o2Layer = o2.getGroupInfo() == null || !StringUtils.hasText((String)o2.getGroupInfo().getName()) ? Integer.MIN_VALUE : o2.getGroupInfo().getBusinessLayer();
            return Integer.compare(o1Layer, o2Layer);
        }).map(groupResource -> {
            if (null != groupResource.getGroupInfo() && StringUtils.hasText((String)groupResource.getGroupInfo().getName())) {
                return new DWTargetResource(groupResource.getGroupInfo().getName(), groupResource.getResources());
            }
            return new DWTargetResource(null, groupResource.getResources());
        }).collect(Collectors.toList());
    }

    private class GroupResource {
        private DWSimplifiedGroupLocationInfo groupInfo;
        private Resource[] resources;

        public GroupResource(DWSimplifiedGroupLocationInfo groupInfo, Resource[] resources) {
            this.groupInfo = groupInfo;
            this.resources = resources;
        }

        public DWSimplifiedGroupLocationInfo getGroupInfo() {
            return this.groupInfo;
        }

        public void setGroupInfo(DWSimplifiedGroupLocationInfo groupInfo) {
            this.groupInfo = groupInfo;
        }

        public Resource[] getResources() {
            return this.resources;
        }

        public void setResources(Resource[] resources) {
            this.resources = resources;
        }
    }
}

