/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate.v2;

import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.candidate.v2.DWApiCandidate;
import com.digiwin.loadbalance.scan.metadata.compress.DWAPiMetadata;
import com.digiwin.loadbalance.util.APITagUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class AbstractApiCandidateV2<T extends DWAPiMetadata>
implements DWApiCandidate<T>,
EnvironmentAware {
    private static Log log = LogFactory.getLog(AbstractApiCandidateV2.class);
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static MetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();
    public AtomicReference<JarFile> currentJarFile = new AtomicReference();
    private static boolean appVersionAble = false;
    private static boolean allVersionAble = false;

    public boolean appVersionAble() {
        return appVersionAble;
    }

    public boolean allVersionAble() {
        return allVersionAble;
    }

    public void setEnvironment(Environment environment) {
        if (null != environment.getProperty("dwappVersion") && !"default".equals(environment.getProperty("dwappVersion"))) {
            appVersionAble = true;
        }
        if ("true".equalsIgnoreCase(environment.getProperty("dwallVersionAble")) && appVersionAble) {
            allVersionAble = true;
        }
    }

    public abstract List<T> resolverPathRegex(MetadataReader var1, String var2);

    @Override
    public List<T> resolver(List<DWTargetResource> targetResourceList) throws IOException {
        HashMap moduleApiMap = new HashMap();
        targetResourceList.stream().filter(targetResource -> StringUtils.hasText((String)targetResource.getPrefix())).forEach(targetResource -> {
            for (Resource resource : targetResource.getResources()) {
                List<Resource> jarFileClassResouces = null;
                try {
                    jarFileClassResouces = this.extractClass(resource);
                }
                catch (IOException e) {
                    log.error((Object)"extractClass faile ", (Throwable)e);
                    continue;
                }
                for (Resource classResouce : jarFileClassResouces) {
                    MetadataReader metadataReader = null;
                    try {
                        InputStream inputStream = classResouce.getInputStream();
                        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                        ByteArrayResource classbytesResource = new ByteArrayResource((byte[])bytes.clone());
                        metadataReader = this.getMetadataReaderFactory().getMetadataReader((Resource)classbytesResource);
                        moduleApiMap.put(targetResource.getPrefix() + metadataReader.getClassMetadata().getClassName(), this.resolverPathRegex(metadataReader, targetResource.getPrefix()));
                        inputStream.close();
                    }
                    catch (Throwable e) {
                        log.error((Object)"getMetadataReader faile ", e);
                    }
                }
                this.closeResource();
            }
        });
        return moduleApiMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Resource> extractClass(Resource resource) throws IOException {
        ArrayList<Resource> classResouceList = new ArrayList<Resource>();
        if (resource.exists() && resource.getURL().getProtocol().equals("file") && !resource.getFile().isDirectory()) {
            log.debug((Object)("file resource :" + resource + " to extractClass class is " + resource.getClass() + " "));
            if (resource.getFilename().endsWith(".jar")) {
                log.debug((Object)("jar resource :" + resource + " to extractClass "));
                List<Resource> jarFileClassResouces = this.getJarFileClassResouces(resource);
                log.debug((Object)("jar resource :" + resource + "extractClass length: " + jarFileClassResouces.size()));
                classResouceList.addAll(jarFileClassResouces);
            } else if (resource.getFilename().endsWith(".class")) {
                classResouceList.add(resource);
            }
        } else if (resource.exists() && resource.getURL().getProtocol().equals("jar")) {
            log.debug((Object)("inner jar resource :" + resource + " to extractClass "));
            JarURLConnection jarUrlConnection = (JarURLConnection)resource.getURL().openConnection();
            String entryName = jarUrlConnection.getEntryName();
            JarFile jarFile = jarUrlConnection.getJarFile();
            this.currentJarFile.set(jarFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!this.getAntPathMatcher().match(entryName + "/**/*.class", jarEntry.getName())) continue;
                classResouceList.add((Resource)new InputStreamResource(jarFile.getInputStream(jarEntry)));
            }
            log.debug((Object)("inner resource :" + resource + "extractClass length: " + classResouceList.size()));
        }
        log.debug((Object)("resource :" + resource + " getclassLength:" + classResouceList.size()));
        return classResouceList;
    }

    private List<Resource> getJarFileClassResouces(Resource jarResource) throws IOException {
        ArrayList<Resource> classResourceList = new ArrayList<Resource>();
        JarFile jarFile = new JarFile(jarResource.getFile());
        this.currentJarFile.set(jarFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.getName().endsWith(".jar")) {
                this.readStream(jarFile.getInputStream(jarEntry), classResourceList);
            }
            if (!jarEntry.getName().endsWith(".class")) continue;
            classResourceList.add((Resource)new InputStreamResource(jarFile.getInputStream(jarEntry)));
        }
        return classResourceList;
    }

    private static byte[] copyStream(InputStream in, ZipEntry entry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long size = entry.getSize();
        if (size > -1L) {
            byte[] buffer = new byte[4096];
            int n = 0;
            for (long count = 0L; -1 != (n = in.read(buffer)) && count < size; count += (long)n) {
                baos.write(buffer, 0, n);
            }
        } else {
            int b;
            while ((b = in.read()) != -1) {
                baos.write(b);
            }
        }
        baos.close();
        return baos.toByteArray();
    }

    private List<Resource> readStream(InputStream jarFileInputStream, List<Resource> resourceList) throws IOException {
        ZipInputStream jarInputStream = new ZipInputStream(jarFileInputStream);
        ZipEntry jarEntry = null;
        while (true) {
            byte[] byteArray;
            try {
                jarEntry = jarInputStream.getNextEntry();
                if (jarEntry == null) {
                }
            }
            catch (Throwable e) {}
            break;
            if (jarEntry.getName().endsWith(".class")) {
                byteArray = new byte[]{};
                try {
                    byteArray = AbstractApiCandidateV2.copyStream(jarInputStream, jarEntry);
                }
                catch (IOException e) {
                    continue;
                }
                InputStreamResource inputStreamSource = new InputStreamResource((InputStream)new ByteArrayInputStream(byteArray));
                resourceList.add((Resource)inputStreamSource);
                continue;
            }
            if (!jarEntry.getName().endsWith(".jar")) continue;
            byteArray = new byte[]{};
            try {
                byteArray = AbstractApiCandidateV2.copyStream(jarInputStream, jarEntry);
            }
            catch (IOException e) {
                continue;
            }
            this.readStream(new ByteArrayInputStream(byteArray), resourceList);
        }
        jarInputStream.close();
        return resourceList;
    }

    @Override
    public int[] getTags(Set<RequestMethod> allowedMehods, boolean versionAble) {
        int tag = 0;
        if (CollectionUtils.isEmpty(allowedMehods)) {
            tag = 8160;
        } else {
            for (RequestMethod requestMethod : allowedMehods) {
                tag += APITagUtils.getRequestTag(requestMethod);
            }
        }
        if (versionAble) {
            tag += 8192;
        }
        return this.processBaseTages(new int[]{tag});
    }

    public abstract int[] processBaseTages(int[] var1);

    public final MetadataReaderFactory getMetadataReaderFactory() {
        return metadataReaderFactory;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }

    @Override
    public void closeResource() {
        JarFile jarFile = this.currentJarFile.get();
        if (jarFile != null) {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Throwable e) {
                log.error((Object)("close jarResouce error :" + jarFile));
            }
        }
        this.currentJarFile.set(null);
    }
}

