/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.app.service.DWService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.AbstractVersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.scan.metadata.CommonApiMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.data.type.classreading.MethodsMetadataReaderFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class DWRestfulApiCandidate
extends AbstractVersionApiCandidate {
    private static Log log = LogFactory.getLog(DWRestfulApiCandidate.class);
    private static String REQUEST_PATH_PREFIX = "/restful/service/";
    private static String[] REQUEST_TYPE_WITHOUT_POST = new String[]{RequestMethod.GET.toString().toLowerCase(), RequestMethod.POST.toString().toLowerCase(), RequestMethod.PATCH.toString().toLowerCase(), RequestMethod.PUT.toString().toLowerCase(), RequestMethod.DELETE.toString().toLowerCase()};
    MethodsMetadataReaderFactory methodsMetadataReaderFactory = new MethodsMetadataReaderFactory();

    @Override
    public List<ApiMetadata> resolverPathRegex(MetadataReader metadataReader, String rootPath) {
        ArrayList<ApiMetadata> apiMetadataList = new ArrayList<ApiMetadata>();
        if (metadataReader.getClassMetadata().isInterface() && Arrays.stream(metadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) {
            String[] resourcePathArray;
            String[] classNameSplit = metadataReader.getClassMetadata().getClassName().split("\\.");
            String intetfaceSimpleName = classNameSplit[classNameSplit.length - 1];
            String resourceRegexStr = "I[^a-z]\\S{1,}Service";
            String[] resourceArray = new String[]{};
            if (intetfaceSimpleName.matches(resourceRegexStr)) {
                String resouceName = intetfaceSimpleName.substring(1, intetfaceSimpleName.length() - 7);
                resourcePathArray = new String[]{intetfaceSimpleName, resouceName, resouceName.substring(0, 1).toLowerCase() + resouceName.substring(1)};
                resourceArray = new String[]{resouceName, resouceName.substring(0, 1).toLowerCase() + resouceName.substring(1)};
            } else {
                resourcePathArray = new String[]{intetfaceSimpleName};
            }
            boolean isAllVersionable = false;
            if (metadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName())) {
                isAllVersionable = true;
            }
            MethodsMetadataReader methodsMetadataReader = null;
            try {
                methodsMetadataReader = this.getMethodsMetadataReaderFactory().getMetadataReader(metadataReader.getResource());
            }
            catch (IOException e) {
                log.error((Object)("read classMethodMetadata failure  module:" + rootPath + "className:" + metadataReader.getClassMetadata().getClassName()), (Throwable)e);
            }
            if (null != methodsMetadataReader) {
                Set methodMetadataSet = methodsMetadataReader.getMethodsMetadata().getMethods();
                for (MethodMetadata methodMetadata : methodMetadataSet) {
                    for (String requestTyep : REQUEST_TYPE_WITHOUT_POST) {
                        if (!methodMetadata.getMethodName().startsWith(requestTyep)) continue;
                        String subMethod = methodMetadata.getMethodName().substring(requestTyep.length());
                        for (String resouce : resourceArray) {
                            apiMetadataList.add(new CommonApiMetadata((REQUEST_PATH_PREFIX + rootPath + "/" + resouce + "/" + subMethod).replaceAll("/$", ""), isAllVersionable || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                            if (!StringUtils.isNotBlank((CharSequence)subMethod)) continue;
                            apiMetadataList.add(new CommonApiMetadata(REQUEST_PATH_PREFIX + rootPath + "/" + resouce + "/" + subMethod.substring(0, 1).toLowerCase() + subMethod.substring(1), isAllVersionable || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                        }
                        break;
                    }
                    for (String resouceNam : resourcePathArray) {
                        apiMetadataList.add(new CommonApiMetadata(REQUEST_PATH_PREFIX + rootPath + "/" + resouceNam + "/" + methodMetadata.getMethodName(), isAllVersionable || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                    }
                }
            }
        }
        return apiMetadataList;
    }

    MethodsMetadataReaderFactory getMethodsMetadataReaderFactory() {
        return this.methodsMetadataReaderFactory;
    }
}

