/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient.reroute;

import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.client.httpclient.BaseHttpRoutePlanner;
import com.digiwin.loadbalance.config.request.LoadbalanceRequestConfig;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DWAttemptReRoutePlanner
extends BaseHttpRoutePlanner {
    private Log log = LogFactory.getLog(this.getClass());

    public DWAttemptReRoutePlanner(AuthenProperties authenProperties, DWLoadBalancerClientFactory loadBalancerClientFactory, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        super(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpContext context) throws HttpException {
        this.log.debug((Object)("httpHost:" + httpHost));
        if (Objects.nonNull(DWLoadBalanceUtils.getLoadBalanceFlag()) && !DWLoadBalanceUtils.getLoadBalanceFlag().booleanValue()) {
            this.log.info((Object)"DWAttemptReRoutePlanner LoadBalanceFlag false");
            DWLoadBalanceUtils.resetFlag();
            DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)false);
            return new HttpRoute(httpHost);
        }
        HttpHost processedHost = this.beforeRoute(httpHost, request, context);
        DWLoadBalanceUtils.resetFlag();
        DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)true);
        context.setAttribute("dwloadbalance.service.name", (Object)processedHost.getHostName());
        HttpRequestWrapper wrapRequest = HttpRequestWrapper.wrap((HttpRequest)request);
        DWLoadBalanceRequestUtils.setRequest((HttpUriRequest)wrapRequest);
        String tenantId = null;
        try {
            tenantId = this.getTenantId(wrapRequest);
            DWLoadBalanceRequestUtils.setTenantId(tenantId);
        }
        catch (Exception e) {
            this.log.error((Object)("get TenantId fail tenantId: " + tenantId), (Throwable)e);
            throw new HttpException("get TenantId fail", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)this.getDiscoveryClient().getInstances(processedHost.getHostName()))) {
            this.log.info((Object)("no service instance named  " + processedHost.getHostName()));
            context.setAttribute("dwloadbalance.service.name", (Object)httpHost.getHostName());
            return new HttpRoute(httpHost);
        }
        this.beforeLoadbalance(processedHost, request, context);
        return new HttpRoute(processedHost);
    }

    @Override
    public void beforeLoadbalance(HttpHost httpHost, HttpRequest request, HttpContext context) {
        super.beforeLoadbalance(httpHost, request, context);
    }
}

