/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.condition;

import com.digiwin.loadbalance.condition.ConditionalOnDWAPi;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

public class DWApiCandidateCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap allAnnotationAttributes = metadata.getAllAnnotationAttributes(ConditionalOnDWAPi.class.getName());
        List value = (List)allAnnotationAttributes.get((Object)"value");
        String candidateValue = ((String)value.get(0)).toUpperCase();
        Environment environment = context.getEnvironment();
        String[] includeStrs = environment.getProperty("dwscan.candidate.include", "EAI,DWRESTFULSERVICE,DWRESTFULSTANDERD,CONTROLLER").toUpperCase().split(",");
        String[] excludeStrs = environment.getProperty("dwscan.candidate.exclude", "").toUpperCase().split(",");
        AtomicBoolean include = new AtomicBoolean(false);
        AtomicBoolean exclude = new AtomicBoolean(false);
        Arrays.stream(includeStrs).filter(name -> {
            if (name.equals("*")) {
                include.set(true);
            }
            if (name.equals(candidateValue)) {
                include.set(true);
            }
            return false;
        }).findAny();
        Arrays.stream(excludeStrs).filter(name -> {
            if (name.equals("*")) {
                exclude.set(true);
            }
            if (name.equals(candidateValue)) {
                exclude.set(true);
            }
            return false;
        }).findAny();
        return include.get() && !exclude.get();
    }
}

