/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.multiple.config;

import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.multiple.module.config.ModuleConfig;
import com.digiwin.loadbalance.multiple.module.config.ModuleRegistrationConfig;
import com.digiwin.loadbalance.multiple.module.listener.MultipleAppInitializedListener;
import com.digiwin.loadbalance.multiple.module.service.MultipleUpdateMetadataService;
import com.digiwin.loadbalance.multiple.namespace.DWMultipleLoadBalancerClientFactory;
import com.digiwin.loadbalance.namespace.LoadBalancerClientSpecification;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.v2.DWCommonScannerV2;
import com.digiwin.loadbalance.service.UpdateMetadataService;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
@ConditionalOnProperty(value={"dap.multiple-app-env", "digiwin.load.balance.autoCongiguration.flage"})
public class MultipleConfig
implements ApplicationListener<WebServerInitializedEvent>,
EnvironmentAware {
    public static final String GROUP_APP_PORT_NAME = "spring.cloud.nacos.discovery.port";
    public static final String GROUP_GLOBAL_PROPERTYSOURCE_NAME = "group.global.propertySrouce.name";
    Environment environment;

    @Bean
    DWMultipleLoadBalancerClientFactory dwMultipleLoadBalancerClientFactory() {
        DWMultipleLoadBalancerClientFactory dwMultipleLoadBalancerClientFactory = new DWMultipleLoadBalancerClientFactory(ModuleConfig.class);
        LoadBalancerClientSpecification loadBalancerClientSpecification = new LoadBalancerClientSpecification("default.configuration", new Class[]{ModuleRegistrationConfig.class});
        dwMultipleLoadBalancerClientFactory.setConfigurations(Arrays.asList(loadBalancerClientSpecification));
        return dwMultipleLoadBalancerClientFactory;
    }

    @Bean
    UpdateMetadataService updateMetadataService(DWMultipleLoadBalancerClientFactory dwMultipleLoadBalancerClientFactory) {
        return new MultipleUpdateMetadataService(dwMultipleLoadBalancerClientFactory);
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        int port = event.getWebServer().getPort();
        if (this.environment instanceof ConfigurableEnvironment) {
            ((ConfigurableEnvironment)this.environment).getPropertySources().addFirst((PropertySource)new MapPropertySource(GROUP_GLOBAL_PROPERTYSOURCE_NAME, Collections.singletonMap(GROUP_APP_PORT_NAME, port)));
        }
    }

    @Bean
    MultipleAppInitializedListener multipleAppListener(DWMultipleLoadBalancerClientFactory dwMultipleLoadBalancerClientFactory, DWResourceHelper dwResourceHelper, Environment environment, DWCommonScanner dwCommonScanner, DWCommonScannerV2 dwCommonScannerV2) {
        MultipleAppInitializedListener multipleAppListener = new MultipleAppInitializedListener(dwMultipleLoadBalancerClientFactory, dwResourceHelper, environment, dwCommonScanner, dwCommonScannerV2);
        ESPLoadBalanceUtil.setMultiple(true);
        ESPLoadBalanceUtil.setMultipleLoadBalancerClientFactory(dwMultipleLoadBalancerClientFactory);
        return multipleAppListener;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

