/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.InitUtils;
import com.alibaba.nacos.client.utils.ValidatorUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.loadbalance.client.DWHttpLoadbalanceRoute;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.esp.ESPExecutorPoolProperties;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.event.RegestionApplicationListener;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
public class DWLoadBalancerAutoConfiguration {
    @Bean
    DWDiscoveryProperties dwDiscoveryProperties(Environment environment, DWCommonScanner dwCommonScanner) throws Exception {
        DWDiscoveryProperties dwDiscoveryProperties = new DWDiscoveryProperties();
        dwDiscoveryProperties.setApiSet(dwCommonScanner.scan());
        return dwDiscoveryProperties;
    }

    @Bean
    public NacosServerListWatcher nacosServerListWatcher(Environment environment, NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosServerListWatcher(nacosServiceManager, nacosDiscoveryProperties);
    }

    @Bean
    public NacosRegistrationCustomizer nacosRegistrationCustomizer(DWDiscoveryProperties dwDiscoveryProperties) {
        return nacosRegistration -> {
            boolean defaultVersionFlag = "default".equals(dwDiscoveryProperties.getAppVersion());
            Map metadata = nacosRegistration.getMetadata();
            this.resetDiscoverProperty(nacosRegistration.getNacosDiscoveryProperties(), dwDiscoveryProperties);
            Iterator<ApiMetadata> apiMetadataIterator = dwDiscoveryProperties.getApiSet().iterator();
            int versionAbleIndex = 0;
            while (apiMetadataIterator.hasNext()) {
                ApiMetadata apiMetadata = apiMetadataIterator.next();
                if (defaultVersionFlag || !apiMetadata.getVersionAble()) continue;
                metadata.put("dw-version-info." + versionAbleIndex + "." + "path", apiMetadata.getVersionAbleId());
                ++versionAbleIndex;
            }
            this.registerEAI(metadata);
            metadata.put("version", dwDiscoveryProperties.getAppVersion());
            metadata.put("describe", dwDiscoveryProperties.getDwappDescribe());
        };
    }

    private void resetDiscoverProperty(NacosDiscoveryProperties nacosDiscoveryProperties, DWDiscoveryProperties dwDiscoveryProperties) {
        nacosDiscoveryProperties.setService(Objects.nonNull(dwDiscoveryProperties.getAppid()) ? dwDiscoveryProperties.getAppid() : dwDiscoveryProperties.getSpringApplicationName());
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)dwDiscoveryProperties.getPort())) {
            nacosDiscoveryProperties.setPort(Integer.valueOf(dwDiscoveryProperties.getPort()).intValue());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dwDiscoveryProperties.getIp())) {
            nacosDiscoveryProperties.setIp(dwDiscoveryProperties.getIp());
        }
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)dwDiscoveryProperties.getWatchDelay())) {
            nacosDiscoveryProperties.setWatchDelay(Long.valueOf(dwDiscoveryProperties.getWatchDelay()).longValue());
        }
        nacosDiscoveryProperties.setUsername(dwDiscoveryProperties.getUsername());
        nacosDiscoveryProperties.setPassword(dwDiscoveryProperties.getPassword());
        nacosDiscoveryProperties.setClusterName(dwDiscoveryProperties.getClusterName());
        nacosDiscoveryProperties.setNamespace(dwDiscoveryProperties.getNamespace());
        nacosDiscoveryProperties.setGroup(dwDiscoveryProperties.getGroup());
    }

    public void registerEAI(Map<String, String> metadata) {
        DWEAIProperties eaiProperties = DWEAIProperties.getProperties();
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
            metadata.put("eai.hostRetryInterval", eaiProperties.getHostRetryInterval());
        }
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
            metadata.put("eai.hostRetryTimes", eaiProperties.getHostRetryTimes());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServicePath())) {
            metadata.put("eai.restfulPath", eaiProperties.getRestfulServicePath());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)eaiProperties.getRestfulServiceCallbackPath())) {
            metadata.put("eai.callbackPath", eaiProperties.getRestfulServiceCallbackPath());
        }
    }

    @Bean
    RegestionApplicationListener regestionApplicationListener(DWDiscoveryProperties dwDiscoveryProperties, NamingProxy namingProxy) {
        return new RegestionApplicationListener(dwDiscoveryProperties, namingProxy);
    }

    @Bean
    NamingProxy namingProxy(NacosDiscoveryProperties nacosDiscoveryProperties) throws NacosException {
        Properties properties = nacosDiscoveryProperties.getNacosProperties();
        ValidatorUtils.checkInitParam((Properties)properties);
        String namespace = InitUtils.initNamespaceForNaming((Properties)properties);
        InitUtils.initSerialization();
        String serverList = properties.getProperty("serverAddr");
        String endpoint = InitUtils.initEndpoint((Properties)properties);
        if (StringUtils.isNotEmpty((String)endpoint)) {
            serverList = "";
        }
        InitUtils.initWebRootContext();
        NamingProxy serverNameProxy = new NamingProxy(namespace, endpoint, serverList, properties);
        return serverNameProxy;
    }

    @Bean
    ESPExecutorPoolProperties espExecutorPoolProperties() {
        return new ESPExecutorPoolProperties();
    }

    @Bean
    public ESPLoadBalanceUtil init(DiscoveryClient discoveryClient, DWHttpLoadbalanceRoute dwRoutePlanner, NacosServerListWatcher nacosServerListWatcher, Environment environment, NacosDiscoveryProperties nacosDiscoveryProperties, ESPExecutorPoolProperties espExecutorPoolProperties, NamingProxy namingProxy) {
        DWEAIProperties eaiProperties = DWEAIProperties.getProperties();
        ESPLoadBalanceUtil espLoadBalanceUtil = new ESPLoadBalanceUtil();
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
            ESPLoadBalanceUtil.setEaiHostRetryInterval(Integer.valueOf(eaiProperties.getHostRetryInterval()));
        }
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
            ESPLoadBalanceUtil.setEaiHostRetryTimes(Integer.valueOf(eaiProperties.getHostRetryTimes()));
        }
        ESPLoadBalanceUtil.setEaiRestfulPath(eaiProperties.getRestfulServicePath());
        ESPLoadBalanceUtil.setEaiCallbackPath(eaiProperties.getRestfulServiceCallbackPath());
        String dwloadBalanceEnable = environment.getProperty("dwloadBalanceEnable");
        if ("true".equals(dwloadBalanceEnable)) {
            ESPLoadBalanceUtil.setLoadBalanceEnable(true);
        }
        ESPLoadBalanceUtil.setDiscoveryClient(discoveryClient);
        ESPLoadBalanceUtil.setDwRoutePlanner(dwRoutePlanner);
        ESPLoadBalanceUtil.setNacosServerListWatcher(nacosServerListWatcher);
        ESPLoadBalanceUtil.setDiscoveryProperties(nacosDiscoveryProperties);
        ESPLoadBalanceUtil.setEspExecutorPoolProperties(espExecutorPoolProperties);
        ESPLoadBalanceUtil.setNamingProxy(namingProxy);
        return espLoadBalanceUtil;
    }
}

