/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.autoconfigure;

import com.digiwin.loadbalance.client.DWHttpLoadbalanceRoute;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.UrlPathMatcher;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.service.TenantIdService;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
public class DWClientLoadBalancerAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={HttpClient.class})
    public DWLoadBalancerClientFactory loadBalancerClientFactory() {
        return new DWLoadBalancerClientFactory();
    }

    @Bean
    public TenantIdService tenantIdService() {
        return new TenantIdService();
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean
    HttpRoutePlanner dwHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        return new DWHttpLoadbalanceRoute(loadBalancerClientFactory);
    }

    @Bean
    DWMatcher urlPathMatcher() {
        return new UrlPathMatcher();
    }
}

