/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.config;

import com.alibaba.nacos.api.exception.NacosException;
import com.digiwin.loadbalance.client.config.DWDefaultTenantServiceConfig;
import com.digiwin.loadbalance.client.config.TenantServiceConfig;
import com.digiwin.loadbalance.loadbalancer.DWClientTenantRoundLoadBalancer;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.EAIMatcher;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.Environment;

@Configuration
public class DWClientLoadBlanceConfigure {
    @Bean
    TenantServiceConfig defaultTenantServiceConfig(Environment environment) {
        String serviceName = environment.getProperty("loadbalancer.client.name");
        return new DWDefaultTenantServiceConfig(serviceName);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceInstanceChooser reactorServiceInstanceLoadBalancer(Environment environment, DiscoveryClient discoveryClient, TenantServiceConfig tenantServiceConfig, NacosServerListWatcher nacosServerListWatcher, List<DWMatcher> matchers) throws NacosException {
        OrderComparator.sort(matchers);
        String name = environment.getProperty("loadbalancer.client.name");
        return new DWClientTenantRoundLoadBalancer(discoveryClient, tenantServiceConfig, name, nacosServerListWatcher, matchers);
    }

    @Bean
    DWMatcher eaiMatcher(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        return new EAIMatcher(nacosServerListWatcher, environment, discoveryClient);
    }
}

