/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;

public class DWHttpLoadbalanceRoute
implements HttpRoutePlanner {
    private static Log log = LogFactory.getLog(DWHttpLoadbalanceRoute.class);
    @Autowired
    TenantIdService tenantIdService;
    private final DWLoadBalancerClientFactory loadBalancerClientFactory;

    public DWHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpContext context) throws HttpException {
        log.info((Object)("httpHost:" + httpHost));
        if (!DWLoadBalanceUtils.getLoadBalanceFlag().booleanValue()) {
            return new HttpRoute(httpHost);
        }
        String token = null;
        Header tokenHeader = request.getFirstHeader("token");
        if (null != tokenHeader) {
            token = tokenHeader.getValue();
        }
        if (StringUtils.isEmpty(token) && null != (tokenHeader = request.getFirstHeader("digi-middleware-auth-user"))) {
            token = tokenHeader.getValue();
        }
        DWLoadBalanceRequestUtils.setRequest((HttpUriRequest)HttpRequestWrapper.wrap((HttpRequest)request));
        try {
            DWLoadBalanceRequestUtils.setTenantId(this.tenantIdService.getTenantId(token));
        }
        catch (Exception e) {
            log.error((Object)"get TenantId fail ", (Throwable)e);
            throw new HttpException("get TenantId fail");
        }
        ServiceInstanceChooser loadBalancer = this.loadBalancerClientFactory.getInstance(httpHost.getHostName());
        ServiceInstance server = loadBalancer.choose(httpHost.getHostName());
        if (null == server) {
            log.error((Object)"find service fail ");
            throw new HttpException("no service was find");
        }
        HttpHost tragetHost = new HttpHost(server.getHost(), server.getPort());
        log.info((Object)("target host:" + tragetHost));
        return new HttpRoute(tragetHost);
    }
}

