/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.esp;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.loadbalancer.DWClientTenantRoundLoadBalancer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class ESPServerNameCacheUtil {
    private static Log log = LogFactory.getLog(DWClientTenantRoundLoadBalancer.class);
    private static Set<String> appNameSet = new CopyOnWriteArraySet<String>();
    private static Cache<String, String> serviceNameCache = CacheBuilder.newBuilder().initialCapacity(2000).maximumSize(6000L).build();

    public static String getServiceId(String serviceName) {
        String appName = (String)serviceNameCache.getIfPresent((Object)serviceName);
        try {
            if (StringUtils.isBlank((CharSequence)appName)) {
                appName = ESPServerNameCacheUtil.searchAppNameByEAIId(serviceName);
            }
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                serviceNameCache.put((Object)serviceName, (Object)appName);
                if (!appNameSet.contains(appName)) {
                    appNameSet.add(appName);
                    ESPLoadBalanceUtil.getNacosServerListWatcher().watch(appName, event -> {
                        if (event instanceof NamingEvent) {
                            log.info((Object)("nacos NamingEvent ServiceName:" + ((NamingEvent)event).getServiceName() + ",clusters:" + ((NamingEvent)event).getClusters()));
                            String[] groupServiceName = ((NamingEvent)event).getServiceName().split("@@");
                            String eventAppName = groupServiceName[groupServiceName.length - 1];
                            serviceNameCache.asMap().entrySet().stream().forEach(entry -> {
                                if (((String)entry.getValue()).equals(eventAppName)) {
                                    serviceNameCache.invalidate(entry.getKey());
                                }
                            });
                        }
                    });
                }
            }
            return appName;
        }
        catch (NacosException e) {
            appNameSet.remove(appName);
            log.error((Object)("NacosException fail to find watch nacos serviceName:" + serviceName), (Throwable)e);
            return null;
        }
    }

    public static boolean serviceMatchEaiId(Map<String, String> serviceMetadata, String eaiId) {
        String key;
        if (CollectionUtils.isEmpty(serviceMetadata)) {
            return false;
        }
        int index = 0;
        while (serviceMetadata.containsKey(key = ESPServerNameCacheUtil.getEaiServiceNameKey(index))) {
            String metadataApi = serviceMetadata.get(key);
            if (eaiId.equals(metadataApi)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static String getEaiServiceNameKey(int index) {
        return String.format("api-info.%d.api-id", index);
    }

    public static boolean dapLoadRoute(String serviceName) {
        return ESPLoadBalanceUtil.getloadBalanceEnable() && StringUtils.isNotBlank((CharSequence)ESPServerNameCacheUtil.getServiceId(serviceName));
    }

    private static String searchAppNameByEAIId(String eaiId) {
        NacosDiscoveryProperties discoveryProperties = ESPLoadBalanceUtil.getDiscoveryProperties();
        NamingProxy namingProxy = ESPLoadBalanceUtil.getNamingProxy();
        List<String> nameList = null;
        Integer pageSize = 30;
        Integer pageNo = 1;
        do {
            Optional<String> anyService;
            if (!CollectionUtils.isEmpty(nameList = ESPServerNameCacheUtil.getServiceList(pageNo, pageSize)) && (anyService = nameList.stream().filter(serviceName -> {
                try {
                    Service service = namingProxy.queryService(serviceName, discoveryProperties.getGroup());
                    return ESPServerNameCacheUtil.serviceMatchEaiId(service.getMetadata(), eaiId);
                }
                catch (NacosException e) {
                    log.error((Object)"query service metadata fail ", (Throwable)e);
                    return false;
                }
            }).findAny()).isPresent()) {
                return anyService.get();
            }
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        } while (!CollectionUtils.isEmpty(nameList));
        return null;
    }

    private static List<String> getServiceList(Integer pageNo, Integer pageSize) {
        NacosDiscoveryProperties discoveryProperties = ESPLoadBalanceUtil.getDiscoveryProperties();
        ListView serviceListView = null;
        try {
            serviceListView = ESPLoadBalanceUtil.getNamingProxy().getServiceList(pageNo.intValue(), pageSize.intValue(), discoveryProperties.getGroup());
        }
        catch (NacosException e) {
            log.error((Object)("get serviceListView fail namespace:" + discoveryProperties.getNamespace() + ",group:" + discoveryProperties.getGroup()), (Throwable)e);
        }
        if (Objects.isNull(serviceListView) || CollectionUtils.isEmpty((Collection)serviceListView.getData())) {
            return new ArrayList<String>();
        }
        return serviceListView.getData();
    }
}

