/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.event;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.dto.SearchServiceResultDto;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class RegestionApplicationListener
implements ApplicationListener {
    private static Log log = LogFactory.getLog(RegestionApplicationListener.class);
    NamingProxy namingProxy;
    DWDiscoveryProperties dwDiscoveryProperties;

    public RegestionApplicationListener(DWDiscoveryProperties dwDiscoveryProperties, NamingProxy namingProxy) {
        this.namingProxy = namingProxy;
        this.dwDiscoveryProperties = dwDiscoveryProperties;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Registration registration;
        if (event instanceof InstancePreRegisteredEvent && (registration = ((InstancePreRegisteredEvent)event).getRegistration()) instanceof NacosRegistration) {
            NacosDiscoveryProperties nacosDiscoveryProperties = ((NacosRegistration)registration).getNacosDiscoveryProperties();
            Service service = this.createLocalService(nacosDiscoveryProperties, this.dwDiscoveryProperties);
            if (!this.checkServiceExist(nacosDiscoveryProperties)) {
                try {
                    this.namingProxy.createService(service, (AbstractSelector)new NoneSelector());
                }
                catch (NacosException e) {
                    log.error((Object)"create nacosServiceException error:", (Throwable)e);
                }
            } else {
                try {
                    this.namingProxy.updateService(service, (AbstractSelector)new NoneSelector());
                }
                catch (NacosException e) {
                    log.error((Object)"update nacosServiceException error:", (Throwable)e);
                }
            }
        }
    }

    private boolean checkServiceExist(NacosDiscoveryProperties nacosDiscoveryProperties) {
        List collect;
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("namespaceId", nacosDiscoveryProperties.getNamespace());
        params.put("groupName", nacosDiscoveryProperties.getGroup());
        params.put("expr", nacosDiscoveryProperties.getService());
        params.put("responsibleOnly", "true");
        String serviceSearch = null;
        try {
            serviceSearch = this.namingProxy.reqApi(UtilAndComs.nacosUrlService + "/names", params, "GET");
        }
        catch (NacosException e) {
            log.error((Object)("search service namespace:" + nacosDiscoveryProperties.getNamespace() + "group:" + nacosDiscoveryProperties.getGroup() + "service:" + nacosDiscoveryProperties.getService() + "error:"), (Throwable)e);
        }
        SearchServiceResultDto searchServiceResultDto = (SearchServiceResultDto)DWGsonProvider.getGson().fromJson(serviceSearch, SearchServiceResultDto.class);
        Map<String, String[]> serviceMap = searchServiceResultDto.getServices();
        String[] nameSpaceServiceArray = serviceMap.get(this.namingProxy.getNamespaceId());
        return nameSpaceServiceArray != null && (collect = Arrays.stream(nameSpaceServiceArray).filter(groupServiceName -> {
            String[] groupServiceStr = groupServiceName.split("@@");
            if (groupServiceStr.length == 2) {
                return groupServiceStr[0].equals(nacosDiscoveryProperties.getGroup()) && groupServiceStr[1].equals(nacosDiscoveryProperties.getService());
            }
            return false;
        }).collect(Collectors.toList())).size() == 1;
    }

    private Service createLocalService(NacosDiscoveryProperties nacosDiscoveryProperties, DWDiscoveryProperties dwDiscoveryProperties) {
        Service service = new Service();
        service.setGroupName(nacosDiscoveryProperties.getGroup());
        service.setName(nacosDiscoveryProperties.getService());
        Iterator<ApiMetadata> apiMetadataIterator = dwDiscoveryProperties.getApiSet().iterator();
        int apiIndex = 0;
        HashMap<String, String> metadata = new HashMap<String, String>();
        while (apiMetadataIterator.hasNext()) {
            ApiMetadata apiMetadata = apiMetadataIterator.next();
            if (!apiMetadata.getRegister()) continue;
            metadata.put("api-info." + apiIndex + "." + "api-id", apiMetadata.getRegisterId());
            ++apiIndex;
        }
        service.setMetadata(metadata);
        return service;
    }
}

