/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.loadbalancer;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.digiwin.loadbalance.client.config.TenantServiceConfig;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWClientTenantRoundLoadBalancer
implements ServiceInstanceChooser {
    private static Log log = LogFactory.getLog(DWClientTenantRoundLoadBalancer.class);
    private final AtomicInteger position;
    private DiscoveryClient discoveryClient;
    private Map<String, Cache<String, List<ServiceInstance>>> servicePathCacheMap;
    private TenantServiceConfig tenantServiceConfig;
    private String serviceId;
    private List<DWMatcher> matchers;

    public DWClientTenantRoundLoadBalancer(DiscoveryClient discoveryClient, TenantServiceConfig tenantServiceConfig, String serviceId, NacosServerListWatcher nacosServerListWatcher, List<DWMatcher> matchers) throws NacosException {
        this.discoveryClient = discoveryClient;
        this.tenantServiceConfig = tenantServiceConfig;
        this.servicePathCacheMap = new ConcurrentHashMap<String, Cache<String, List<ServiceInstance>>>();
        this.serviceId = serviceId;
        this.position = new AtomicInteger(new Random().nextInt(1000));
        this.matchers = matchers;
        nacosServerListWatcher.watch(serviceId, event -> {
            if (event instanceof NamingEvent) {
                this.servicePathCacheMap.clear();
            }
        });
    }

    public ServiceInstance choose(String serviceId) {
        String tenantId = this.getTentid();
        DWMatcher matcher = this.getMatcher(DWLoadBalanceRequestUtils.getRequest());
        HttpUriRequest request = DWLoadBalanceRequestUtils.getRequest();
        String cacheKey = matcher.getCacheKey(DWLoadBalanceRequestUtils.getRequest());
        String tenantServiceVersion = this.tenantServiceConfig.getServiceVersion(tenantId);
        List targetInstances = null;
        Cache pathListCache = this.servicePathCacheMap.get(tenantServiceVersion);
        if (Objects.isNull(pathListCache)) {
            pathListCache = CacheBuilder.newBuilder().initialCapacity(300).maximumSize(600L).build();
            this.servicePathCacheMap.put(tenantServiceVersion, (Cache<String, List<ServiceInstance>>)pathListCache);
        }
        try {
            targetInstances = StringUtils.hasText((String)cacheKey) ? (List)pathListCache.get((Object)cacheKey, () -> this.getInstances(tenantServiceVersion, request, matcher)) : this.getInstances(tenantServiceVersion, request, matcher);
        }
        catch (ExecutionException e) {
            log.error((Object)("fail to find serviceInstances tenantId:" + tenantId + " cacheKey:" + cacheKey + " serviceId:" + serviceId + " version:" + tenantServiceVersion), (Throwable)e);
        }
        ServiceInstance serviceInstance = this.selectInstance(targetInstances, tenantId);
        return serviceInstance;
    }

    List<ServiceInstance> getInstances(String tenantServiceVersion, HttpUriRequest request, DWMatcher matcher) {
        List discoverInstances = null;
        if (!"default".equals(tenantServiceVersion)) {
            discoverInstances = this.discoveryClient.getInstances(this.serviceId).stream().filter(instance -> tenantServiceVersion.equals(instance.getMetadata().get("version"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(discoverInstances)) {
                return new ArrayList<ServiceInstance>();
            }
            discoverInstances = discoverInstances.stream().filter(instance -> this.instancePathMatch((ServiceInstance)instance, request, matcher)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(discoverInstances)) {
            discoverInstances = this.discoveryClient.getInstances(this.serviceId).stream().filter(instance -> !this.instancePathMatch((ServiceInstance)instance, request, matcher)).collect(Collectors.toList());
        }
        return discoverInstances;
    }

    public boolean instancePathMatch(ServiceInstance serviceInstance, HttpUriRequest request, DWMatcher matcher) {
        String key;
        Map metadata = serviceInstance.getMetadata();
        int index = 0;
        while (metadata.containsKey(key = String.format("dw-version-info.%d.path", index))) {
            String pathRegex = (String)metadata.get(key);
            if (matcher.match(pathRegex, request)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private ServiceInstance selectInstance(List<ServiceInstance> serviceInstanceList, String tenantId) {
        if (CollectionUtils.isEmpty(serviceInstanceList)) {
            return null;
        }
        int pos = this.position.incrementAndGet() & Integer.MAX_VALUE;
        return serviceInstanceList.get(pos % serviceInstanceList.size());
    }

    private String getTentid() {
        return DWLoadBalanceRequestUtils.getTenantId();
    }

    private DWMatcher getMatcher(HttpUriRequest request) {
        return this.matchers.stream().filter(matcher -> matcher.canApply(request)).findFirst().get();
    }
}

