/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.loadbalance.scan.candidate.DWAbstractResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class DWModuleResourceHelper
extends DWAbstractResourceHelper {
    private Log log = LogFactory.getLog(DWModuleResourceHelper.class);

    @Override
    public List<DWTargetResource> getDWTargetResource(Environment environment) {
        ArrayList<DWTargetResource> dwTargetResourceList = new ArrayList<DWTargetResource>();
        List classPathScanList = (List)environment.getProperty("digiwin.service.path.version.scan.packages", List.class);
        if (!CollectionUtils.isEmpty((Collection)classPathScanList)) {
            for (String path : classPathScanList) {
                Resource[] resources = new Resource[]{};
                try {
                    resources = this.getResources(path);
                }
                catch (IOException e) {
                    this.log.error((Object)("get class path resource fail path:" + path), (Throwable)e);
                }
                dwTargetResourceList.add(new DWTargetResource(null, resources));
            }
        }
        List<String> moduleScanPathList = this.getModuleScanPathList();
        for (String modulePath : moduleScanPathList) {
            Resource[] resources = new Resource[]{};
            try {
                resources = this.getResources(modulePath);
            }
            catch (IOException e) {
                this.log.error((Object)("get module path fail modulePath:" + modulePath), (Throwable)e);
            }
            if (null == resources) continue;
            Arrays.stream(resources).forEach(resource -> {
                String moduleName = this.getModuleName((Resource)resource);
                if (StringUtils.hasText((String)moduleName)) {
                    dwTargetResourceList.add(new DWTargetResource(moduleName, new Resource[]{resource}));
                }
            });
        }
        return dwTargetResourceList;
    }

    public List<String> getModuleScanPathList() {
        String urlPath;
        ArrayList<String> moduleScanPathList = new ArrayList<String>();
        for (String path : DWModuleSpringUtils.getPlatformModulePaths()) {
            urlPath = this.getClassPathUrlString(path);
            if (!StringUtils.hasText((String)urlPath)) continue;
            moduleScanPathList.add(urlPath);
        }
        for (String path : DWModuleSpringUtils.getApplicationModulePaths()) {
            urlPath = this.getClassPathUrlString(path);
            if (!StringUtils.hasText((String)urlPath)) continue;
            moduleScanPathList.add(urlPath);
        }
        return moduleScanPathList;
    }

    private String getClassPathUrlString(String filePath) {
        try {
            return ResourceUtils.getURL((String)filePath).toString();
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("file path not found:" + filePath), (Throwable)e);
            return null;
        }
    }

    public String getModuleName(Resource jarResource) {
        Optional<String> anyModuleName;
        String jarResouceUrlString;
        if (jarResource.exists() && jarResource.isFile() && jarResource.getFilename().endsWith(".jar") && StringUtils.hasText((String)(jarResouceUrlString = this.getResouceUrlString(jarResource))) && (anyModuleName = this.getModuleScanPathList().stream().filter(moduleRoot -> {
            String regex = moduleRoot + "{1,2}(\\S{1,})/{1,2}(\\S{1,}).jar";
            return jarResouceUrlString.matches(regex);
        }).map(moduleRoot -> {
            String regex = moduleRoot + "{1,2}(\\S{1,})/{1,2}(\\S{1,}).jar";
            Pattern pattern = Pattern.compile(regex);
            Matcher jarMatcher = pattern.matcher(jarResouceUrlString);
            if (jarMatcher.find()) {
                return jarMatcher.group(1);
            }
            return null;
        }).findAny()).isPresent()) {
            return anyModuleName.get();
        }
        return null;
    }

    private String getResouceUrlString(Resource resource) {
        if (resource.exists() && resource.isFile() && resource.getFilename().endsWith(".jar")) {
            try {
                return resource.getURL().toString();
            }
            catch (IOException e) {
                this.log.error((Object)("getResouceUrlString can't get resource fileName:" + resource.getFilename()), (Throwable)e);
            }
        }
        return null;
    }
}

