/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.loadbalance.extend.spi.DWRouteProcess;
import com.digiwin.loadbalance.extend.spi.DWRouteProcessServiceLocated;
import com.digiwin.loadbalance.multiple.util.MutipleAppUtil;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public abstract class BaseHttpRoutePlanner
implements HttpRoutePlanner {
    private static Log log = LogFactory.getLog(BaseHttpRoutePlanner.class);
    public static final AtomicBoolean inited = new AtomicBoolean(false);
    final AuthenProperties authenProperties;
    private final DWLoadBalancerClientFactory loadBalancerClientFactory;
    final TenantIdService tenantIdService;
    DiscoveryClient discoveryClient;
    MultipleAPPProperties multipleAPPProperties;

    public BaseHttpRoutePlanner(AuthenProperties authenProperties, DWLoadBalancerClientFactory loadBalancerClientFactory, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties) {
        this.authenProperties = authenProperties;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        this.tenantIdService = tenantIdService;
        this.discoveryClient = discoveryClient;
        this.multipleAPPProperties = multipleAPPProperties;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (inited.get()) return;
        Class<BaseHttpRoutePlanner> clazz = BaseHttpRoutePlanner.class;
        synchronized (BaseHttpRoutePlanner.class) {
            inited.compareAndSet(false, true);
            this.loadExtendProcess();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void loadExtendProcess() {
        DWRouteProcessServiceLocated.load();
    }

    public HttpHost beforeRoute(HttpHost httpHost, HttpRequest request) {
        if (null == httpHost || null == request) {
            throw new IllegalArgumentException("httphost and request must not be null");
        }
        DWRouteProcess extendProcesse = DWRouteProcessServiceLocated.getPriorityProcess();
        if (null == extendProcesse) {
            return httpHost;
        }
        HttpHost processedHost = extendProcesse.beforeRoute(httpHost, request);
        if (null == processedHost) {
            return httpHost;
        }
        return processedHost;
    }

    public AuthenProperties getAuthenProperties() {
        return this.authenProperties;
    }

    public DWLoadBalancerClientFactory getLoadBalancerClientFactory() {
        return this.loadBalancerClientFactory;
    }

    public String getTenantId(HttpRequestWrapper wrapRequest) throws Exception {
        String tenantId = null;
        tenantId = this.getRouteKey(wrapRequest);
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            log.info((Object)("loadbalanceRoute routeKey:" + tenantId + ",url:" + String.valueOf(wrapRequest.getURI())));
            return tenantId;
        }
        String token = this.getToken(wrapRequest);
        log.info((Object)("loadbalanceRoute token:" + token + ",url:" + String.valueOf(wrapRequest.getURI())));
        tenantId = this.tenantIdService.getTenantId(token);
        return tenantId;
    }

    private String getRouteKey(HttpRequestWrapper wrapRequest) {
        return this.getPriorityRequestHeader(wrapRequest, this.getAuthenProperties().getRouteKeyNamesList());
    }

    private String getToken(HttpRequestWrapper wrapRequest) {
        return this.getPriorityRequestHeader(wrapRequest, this.getAuthenProperties().getTokenNamesList());
    }

    private String getPriorityRequestHeader(HttpRequestWrapper wrapRequest, List<String> names) {
        for (String name : names) {
            Header header = wrapRequest.getFirstHeader(name);
            if (null == header) continue;
            return header.getValue();
        }
        return null;
    }

    public DiscoveryClient getDiscoveryClient() {
        return this.multipleAPPProperties.isMultipleApp() ? (DiscoveryClient)this.loadBalancerClientFactory.getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), DiscoveryClient.class) : this.discoveryClient;
    }
}

