/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.client.httpclient.BaseHttpRoutePlanner;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.util.CollectionUtils;

public class DWAttemptHttpLoadbalanceRoute
extends BaseHttpRoutePlanner {
    private static Log log = LogFactory.getLog(DWAttemptHttpLoadbalanceRoute.class);

    public DWAttemptHttpLoadbalanceRoute(AuthenProperties authenProperties, DWLoadBalancerClientFactory loadBalancerClientFactory, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties) {
        super(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties);
    }

    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpContext context) throws HttpException {
        log.debug((Object)("httpHost:" + String.valueOf(httpHost)));
        if (Objects.nonNull(DWLoadBalanceUtils.getLoadBalanceFlag()) && !DWLoadBalanceUtils.getLoadBalanceFlag().booleanValue()) {
            log.debug((Object)"DWAttemptHttpLoadbalanceRoute LoadBalanceFlag false");
            DWLoadBalanceUtils.resetFlag();
            DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)false);
            return new HttpRoute(httpHost);
        }
        DWLoadBalanceUtils.resetFlag();
        DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)true);
        HttpHost processedHost = this.beforeRoute(httpHost, request);
        context.setAttribute("dwloadbalance.service.name", (Object)processedHost.getHostName());
        if (CollectionUtils.isEmpty((Collection)this.discoveryClient.getInstances(processedHost.getHostName()))) {
            log.info((Object)("no service instance named  " + processedHost.getHostName()));
            context.setAttribute("dwloadbalance.service.name", (Object)httpHost.getHostName());
            return new HttpRoute(httpHost);
        }
        HttpRequestWrapper wrapRequest = HttpRequestWrapper.wrap((HttpRequest)request);
        DWLoadBalanceRequestUtils.setRequest((HttpUriRequest)wrapRequest);
        String tenantId = null;
        try {
            tenantId = this.getTenantId(wrapRequest);
            DWLoadBalanceRequestUtils.setTenantId(tenantId);
        }
        catch (Exception e) {
            log.error((Object)("get TenantId fail tenantId: " + tenantId), (Throwable)e);
            throw new HttpException("get TenantId fail", (Throwable)e);
        }
        ServiceInstanceChooser loadBalancer = this.getLoadBalancerClientFactory().getInstance(processedHost.getHostName());
        ServiceInstance server = loadBalancer.choose(processedHost.getHostName());
        if (null == server) {
            log.error((Object)("find service fail host:" + String.valueOf(processedHost) + ", url:" + String.valueOf(wrapRequest.getURI()) + ",tenantId:" + tenantId));
            context.setAttribute("dwloadbalance.service.name", (Object)httpHost.getHostName());
            return new HttpRoute(httpHost);
        }
        HttpHost tragetHost = new HttpHost(server.getHost(), server.getPort());
        log.info((Object)("target host:" + String.valueOf(tragetHost) + " for: " + String.valueOf(processedHost)));
        return new HttpRoute(tragetHost);
    }
}

