/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.service;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.digiwin.loadbalance.autoconfigure.DWLoadBalancerAutoConfiguration;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.scan.metadata.compress.DWAPiMetadata;
import com.digiwin.loadbalance.scan.metadata.compress.DWCommonApiMetadata;
import com.digiwin.loadbalance.service.UpdateMetadataService;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.client.serviceregistry.Registration;

public class DefaultUpdateMetadataService
extends UpdateMetadataService {
    private NacosRegistration nacosRegistration;
    private NacosServiceRegistry nacosServiceRegistry;
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private DWDiscoveryProperties dwDiscoveryProperties;
    NamingProxy namingClientProxy;

    public DefaultUpdateMetadataService(NacosRegistration nacosRegistration, NacosServiceRegistry nacosServiceRegistry, NacosDiscoveryProperties nacosDiscoveryProperties, DWDiscoveryProperties dwDiscoveryProperties, NamingProxy namingProxy) {
        this.nacosRegistration = nacosRegistration;
        this.nacosServiceRegistry = nacosServiceRegistry;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.dwDiscoveryProperties = dwDiscoveryProperties;
        this.namingClientProxy = namingProxy;
    }

    @Override
    public void updateInstanceMetadata(Map<String, int[]> metadata) {
        Set<DWAPiMetadata> apiSetV2 = this.dwDiscoveryProperties.getApiSetV2();
        for (Map.Entry<String, int[]> entry : metadata.entrySet()) {
            DWCommonApiMetadata dwCommonApiMetadata = new DWCommonApiMetadata(entry.getKey(), entry.getValue());
            if (!apiSetV2.add(dwCommonApiMetadata)) continue;
            this.nacosDiscoveryProperties.getMetadata().put("dwapi." + DWLoadBalancerAutoConfiguration.apiIndexV2.getAndIncrement(), dwCommonApiMetadata.getInstanceApi());
        }
        this.nacosServiceRegistry.register((Registration)this.nacosRegistration);
        this.dwDiscoveryProperties.initEaiApiSet();
    }

    @Override
    public void updateServiceMetadataIfNeed() throws NacosException {
        Service remoteService = this.namingClientProxy.queryService(this.nacosDiscoveryProperties.getService(), this.nacosDiscoveryProperties.getGroup());
        Map remoteServiceMetadata = remoteService.getMetadata();
        Set<DWAPiMetadata> eaiSetV2 = this.dwDiscoveryProperties.getEaiSetV2();
        boolean metadataChanged = false;
        for (DWAPiMetadata eaiApi : eaiSetV2) {
            if (remoteServiceMetadata.containsKey(eaiApi.getAPIid())) continue;
            metadataChanged = true;
            break;
        }
        if (!metadataChanged) {
            return;
        }
        eaiSetV2.stream().forEach(eaiMetadata -> remoteServiceMetadata.putIfAbsent(eaiMetadata.getAPIid(), eaiMetadata.getAPIid()));
        remoteService.setMetadata(remoteServiceMetadata);
        this.namingClientProxy.updateService(remoteService, (AbstractSelector)new NoneSelector());
    }

    @Override
    public void updateInstanceMetadata(String appId, Map<String, int[]> metadata) {
        this.updateInstanceMetadata(metadata);
    }

    @Override
    public void updateServiceMetadataIfNeed(String appId) throws NacosException {
        this.updateServiceMetadataIfNeed();
    }
}

