/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.autoconfigure;

import com.digiwin.app.log.operation.aop.DWLogOperationInterceptor;
import com.digiwin.app.log.operation.autoconfigure.condition.DWLogOperationCondition;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWriter;
import com.digiwin.app.log.operation.config.DWLogOperationPointcutProperties;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.config.DWLogOperationThreadProperties;
import com.digiwin.app.log.operation.dao.DWLogOperationDaoImp;
import com.digiwin.app.log.operation.dao.ILogOperationDao;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWLogOperationAutoConfiguration {
    private static final Log LOGGER_ = LogFactory.getLog(DWLogOperationAutoConfiguration.class);

    @Bean(name={"dw-log-operation-configuration-properties"})
    @Conditional(value={DWLogOperationCondition.class})
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="dap.dwlog.operation", value={"enabled"}, havingValue="true", matchIfMissing=false)
    public DWLogOperationProperties dwLogOperationConfigProperties(ApplicationContext context) {
        DWLogOperationProperties logOperationProperties = null;
        boolean operateLogEnabled = DWLogOperationCondition.isLogOperationEnabled(context.getEnvironment());
        if (operateLogEnabled) {
            Binder binder = Binder.get((Environment)context.getEnvironment());
            IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
            ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation");
            BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationProperties.class), (BindHandler)handler);
            logOperationProperties = (DWLogOperationProperties)bindResult.get();
        } else {
            logOperationProperties = new DWLogOperationProperties();
        }
        LOGGER_.info((Object)logOperationProperties.toString());
        return logOperationProperties;
    }

    @Bean(name={"dw-log-operation-db-dataSource"})
    @ConditionalOnBean(name={"dw-log-operation-configuration-properties"})
    public DataSource dwLogOperationDaoDataSource(ApplicationContext context, @Qualifier(value="dw-log-operation-configuration-properties") DWLogOperationProperties logOperationProperties) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.datasource");
        BindResult result = binder.bind(cfgPropertyName, Bindable.of(DataSourceProperties.class), (BindHandler)handler);
        DataSource defaultDataSource = ((DataSourceProperties)result.get()).initializeDataSourceBuilder().build();
        LOGGER_.info((Object)("dw-log-operation-db-dataSource: using " + defaultDataSource.getClass().toString()));
        return defaultDataSource;
    }

    @Bean(name={"dw-log-operation-thread-configuration"})
    @ConditionalOnBean(name={"dw-log-operation-configuration-properties"})
    public DWLogOperationThreadProperties dwLogOperationThreadProperties(ApplicationContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.writer.thread");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationThreadProperties.class), (BindHandler)handler);
        DWLogOperationThreadProperties threadProperties = null;
        threadProperties = bindResult.isBound() ? (DWLogOperationThreadProperties)bindResult.get() : new DWLogOperationThreadProperties();
        LOGGER_.info((Object)threadProperties.toString());
        return threadProperties;
    }

    @Bean(name={"dw-log-operation-writer"})
    @ConditionalOnBean(name={"dw-log-operation-thread-configuration"})
    public DWLogOperationWriter dwLogOperationWriter(@Qualifier(value="dw-log-operation-db-dataSource") DataSource dataSource, @Qualifier(value="dw-log-operation-thread-configuration") DWLogOperationThreadProperties threadProperties) {
        DWLogOperationWriter dwLogOperationWriter = new DWLogOperationWriter();
        dwLogOperationWriter.setThreadProperties(threadProperties);
        dwLogOperationWriter.setDataSource(dataSource);
        return dwLogOperationWriter;
    }

    @Bean(name={"dw-log-operation-dao"})
    @ConditionalOnBean(name={"dw-log-operation-writer"})
    public ILogOperationDao dwLogOperationDao(@Qualifier(value="dw-log-operation-writer") DWLogOperationWriter dwLogOperationWriter) {
        DWLogOperationDaoImp dwLogOperationDao = new DWLogOperationDaoImp(dwLogOperationWriter);
        return dwLogOperationDao;
    }

    @Bean(name={"dw-log-operation-interceptor"})
    @ConditionalOnBean(name={"dw-log-operation-dao"})
    public DWLogOperationInterceptor dwLogOperationInterceptor(@Qualifier(value="dw-log-operation-configuration-properties") DWLogOperationProperties logOperateProperties, @Qualifier(value="dw-log-operation-dao") ILogOperationDao dwLogOperationDao) {
        DWLogOperationInterceptor dwLogOperationInterceptor = new DWLogOperationInterceptor();
        return dwLogOperationInterceptor;
    }

    @Bean(name={"dw-log-operation-aop-pointcut-configuration"})
    @ConditionalOnBean(name={"dw-log-operation-configuration-properties"})
    public DWLogOperationPointcutProperties dwLogOperationPointcutProperties(ApplicationContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.aop.pointcut");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationPointcutProperties.class), (BindHandler)handler);
        DWLogOperationPointcutProperties pointcutProperties = null;
        pointcutProperties = bindResult.isBound() ? (DWLogOperationPointcutProperties)bindResult.get() : new DWLogOperationPointcutProperties();
        LOGGER_.info((Object)("[DWLogOperationAutoConfiguration] pointcut properties:" + pointcutProperties.toString()));
        return pointcutProperties;
    }

    @Bean(name={"dw-log-operation-pointcut-advisor"})
    @ConditionalOnBean(name={"dw-log-operation-aop-pointcut-configuration"})
    public DefaultPointcutAdvisor dwLogOperationPointcutAdvisor(@Qualifier(value="dw-log-operation-interceptor") DWLogOperationInterceptor dwLogOperationInterceptor, @Qualifier(value="dw-log-operation-aop-pointcut-configuration") DWLogOperationPointcutProperties pointcutProperties) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(pointcutProperties.getExpression());
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwLogOperationInterceptor);
        advisor.setOrder(pointcutProperties.getOrder());
        LOGGER_.info((Object)advisor.toString());
        return advisor;
    }
}

