/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.utils;

import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationAnnotationField;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLogOperationPropertyUtil {
    private static Log LOGGER_ = LogFactory.getLog(DWLogOperationPropertyUtil.class);

    public static boolean getEnabled(Map<String, Object> sqlLogOptions) {
        String operateLogEnabled = (String)sqlLogOptions.getOrDefault("logOperationEnabled", "false");
        if (BooleanUtils.toBoolean((String)operateLogEnabled)) {
            return BooleanUtils.toBooleanObject((String)operateLogEnabled);
        }
        return false;
    }

    public static DWLogOperationAnnotationField updateOperatLogEnabledInfo(DWLogOperationProperties operateLogProperties, DWLogOperation dwLogOperationAnnotation) {
        Objects.requireNonNull(operateLogProperties, "operateLogProperties is required");
        DWLogOperationAnnotationField annoField = DWLogOperationContext.getContext().getOperateLog();
        annoField.setMergedLogBasicEnable(operateLogProperties.isEnabled());
        if (operateLogProperties.isEnabled() && dwLogOperationAnnotation != null) {
            if (annoField == null) {
                annoField = new DWLogOperationAnnotationField();
            }
            annoField.setOperateDesc(dwLogOperationAnnotation.desc());
            annoField.setOperateType(dwLogOperationAnnotation.type());
            annoField.setOperateMenu(dwLogOperationAnnotation.menu());
            annoField.setOperateStatus(dwLogOperationAnnotation.status());
            annoField.setMergedLogSqlEnabled(DWLogOperationPropertyUtil.getCombinedBoolean("isLogSqlRecord", operateLogProperties.isLogSqlEnabled(), dwLogOperationAnnotation.logSql()));
            annoField.setMergedLogErrorEnabled(DWLogOperationPropertyUtil.getCombinedBoolean("isLogErrorRecord", operateLogProperties.isLogErrorEnabled(), dwLogOperationAnnotation.logError()));
        } else {
            annoField.setMergedLogSqlEnabled(operateLogProperties.isLogSqlEnabled());
            annoField.setMergedLogErrorEnabled(operateLogProperties.isLogErrorEnabled());
        }
        return annoField;
    }

    private static boolean getCombinedBoolean(String property, boolean topLevel, boolean secondLevel) {
        boolean returnValue = false;
        returnValue = topLevel ? secondLevel : topLevel;
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)String.format("[%s] vaule=%b (properties:%b, annotation:%b)", property, returnValue, topLevel, secondLevel));
        }
        return returnValue;
    }
}

