/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.utils;

import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.model.DWLogOperationServiceInfoData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DWLogOperationDataHelper {
    private static int stringMaxLength = 1000;

    public static String generateLogId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getParameterData(MethodInvocation invocation) {
        Parameter[] parametersObj = invocation.getMethod().getParameters();
        ArrayList<String> parametersData = new ArrayList<String>();
        for (Parameter p : parametersObj) {
            StringBuilder rowTemp = new StringBuilder();
            if (p == null) {
                rowTemp.append("(Unknown)");
            } else {
                rowTemp.append(((Object)p).toString());
                rowTemp.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            parametersData.add(rowTemp.toString());
        }
        String argsValue = DWLogOperationDataHelper.getInputValueReadableData(invocation);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{argsValue})) {
            parametersData.add(argsValue);
        }
        String result = StringUtils.join((Object[])parametersData.toArray(), (String)";;");
        return result;
    }

    public static String getReturnValueReadableData(Object result) {
        if (result == null) {
            return "";
        }
        String objectJson = DWLogOperationDataHelper.convertToJson(result);
        String returnValue = StringUtils.abbreviate((String)objectJson, (int)stringMaxLength);
        return returnValue;
    }

    public static String getInputValueReadableData(MethodInvocation invocation) {
        StringBuilder message = new StringBuilder();
        Object[] arguments = invocation.getArguments();
        if (arguments == null) {
            message.append(arguments);
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                if (i != 0) {
                    message.append(", ");
                }
                if (arguments[i] == null) {
                    message.append("null");
                    continue;
                }
                String a = DWLogOperationDataHelper.convertToJson(arguments[i]);
                message.append((Object)a);
            }
        }
        return StringUtils.abbreviate((String)message.toString(), (int)stringMaxLength);
    }

    private static String convertToJson(Object sourceData) {
        Gson gsonParser = new GsonBuilder().serializeNulls().create();
        String objectJson = gsonParser.toJson(sourceData);
        return objectJson;
    }

    public static String getRequestPath() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return request.getRequestURI();
    }

    public static void putSqlMap(Map<String, Object> newSqlRow) {
        DWLogOperationServiceInfoData serviceInfoData = DWLogOperationContext.getContext().getServiceInfoData();
        Map<Integer, Object> logRecordSqlMap = serviceInfoData.getSqlMap();
        logRecordSqlMap.put(logRecordSqlMap.size() + 1, newSqlRow);
    }
}

