/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.vo;

import com.digiwin.app.log.operation.model.DWLogOperationServiceInfoData;
import com.digiwin.app.log.operation.model.DWLogOperationSqlCommandEntity;
import com.digiwin.app.log.operation.utils.DWLogOperationDataHelper;
import com.digiwin.app.log.operation.vo.DWLogAbstractOperationVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DWLogOperationSqlVo
extends DWLogAbstractOperationVo {
    public DWLogOperationSqlVo(String serviceOpLogId) {
        this.setOpMainLogId(serviceOpLogId);
        this.setTargetTableName("dw_log_operation_sql");
    }

    @Override
    public Object getData() {
        return this.filterData();
    }

    public List<DWLogOperationSqlCommandEntity> filterData() {
        ArrayList<DWLogOperationSqlCommandEntity> listData = new ArrayList<DWLogOperationSqlCommandEntity>();
        try {
            DWLogOperationServiceInfoData serviceInfoData = this.getLogOperationContext().getServiceInfoData();
            Map<Integer, Object> sqlMap = serviceInfoData.getSqlMap();
            if (MapUtils.isNotEmpty(sqlMap)) {
                for (Integer key : sqlMap.keySet()) {
                    DWLogOperationSqlCommandEntity sqlCommandModel = new DWLogOperationSqlCommandEntity();
                    Map rowSqlMap = (Map)sqlMap.get(key);
                    sqlCommandModel.setServiceLogId(this.getOpMainLogId());
                    sqlCommandModel.setLogId(DWLogOperationDataHelper.generateLogId());
                    sqlCommandModel.setExecuteTableName((String)rowSqlMap.get("tableName"));
                    sqlCommandModel.setExecuteCommand((String)rowSqlMap.get("statement"));
                    sqlCommandModel.setExecuteParameter(this.getSqlParamters(rowSqlMap.get("parameters")));
                    sqlCommandModel.setExecuteSeq(key);
                    sqlCommandModel.setTenantSid(serviceInfoData.getTenantSid());
                    listData.add(sqlCommandModel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listData;
    }

    private String getSqlParamters(Object paramsObj) {
        ArrayList<String> parametersData = new ArrayList<String>();
        for (Object p : (List)paramsObj) {
            StringBuilder rowTemp = new StringBuilder();
            rowTemp.append(p.toString());
            parametersData.add(rowTemp.toString());
        }
        return StringUtils.join((Object[])parametersData.toArray(), (String)";;");
    }

    private String getRunnableSqlStatement(Map<String, Object> rowSqlMap) {
        String sqlStatement = (String)rowSqlMap.get("statement");
        Object paramsObj = rowSqlMap.get("parameters");
        if (StringUtils.isNotEmpty((CharSequence)sqlStatement) && paramsObj != null) {
            List params = (List)paramsObj;
            for (Object value : params) {
                if (value instanceof String) {
                    sqlStatement = sqlStatement.replaceFirst("\\?", "'" + value.toString() + "'");
                    continue;
                }
                sqlStatement = sqlStatement.replaceFirst("\\?", value.toString());
            }
        } else {
            return sqlStatement;
        }
        return sqlStatement;
    }
}

