/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.config;

import com.digiwin.app.log.operation.config.DWLogOperationEnv;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DWLogOperationEnvAdapter {
    private static final Log LOGGER_ = LogFactory.getLog(DWLogOperationEnvAdapter.class);
    @Autowired
    Environment environment;
    private DWLogOperationEnv logOperationEnv = new DWLogOperationEnv();

    public void initSystemProperties() {
        if (StringUtils.isBlank((CharSequence)System.getProperty("tenantEnabled"))) {
            String tenantEnabledStr = this.environment.getProperty("tenantEnabled", "true");
            this.updateSystemProperty("tenantEnabled", tenantEnabledStr);
            this.logOperationEnv.setTenantEnabled(tenantEnabledStr);
        }
        if (StringUtils.isBlank((CharSequence)System.getProperty("tenantColumnname"))) {
            String tenantsidColumnName = this.environment.getProperty("tenantColumnname", "tenantsid");
            this.updateSystemProperty("tenantColumnname", tenantsidColumnName);
            this.logOperationEnv.setTenantColumnName(tenantsidColumnName);
        }
    }

    public void updateSystemProperty(String key, String value) {
        System.setProperty(key, value);
        LOGGER_.info((Object)String.format("[DWLogOperationEnvAdapter.initSystemProperties] update System property: %s=%s", key, value));
    }

    public DWLogOperationEnv getLogOperationEnv() {
        return this.logOperationEnv;
    }

    public void setLogOperationEnv(DWLogOperationEnv logOperationEnv) {
        this.logOperationEnv = logOperationEnv;
    }
}

