/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;

@Plugin(name="DwLogMongoAppender", category="Core", elementType="appender", printObject=true)
public class DwLogMongoAppender
extends AbstractAppender {
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoCollection<BasicDBObject> logsCollection;
    private String connectionUrl;
    private String userName;
    private String password;
    private String databaseName;
    private String collectionName;
    private String app;

    protected DwLogMongoAppender(String name, Filter filter, Layout<? extends Serializable> layout, String databaseName, String collectionName, String server, String port, String userName, String password) {
        super(name, filter, layout);
        if (userName == null || userName == "") {
            this.setConnectionUrl("mongodb://" + server + ":" + port);
        } else {
            this.setConnectionUrl("mongodb://" + userName + ":" + password + "@" + server + ":" + port);
        }
        this.setDatabaseName(databaseName);
        this.setCollectionName(collectionName);
        String app = DWApplicationConfigUtils.getProperty((String)"appId");
        this.setApp(app);
    }

    public void append(LogEvent event) {
        if (this.mongoDatabase == null) {
            MongoClientURI connectionString = new MongoClientURI(this.connectionUrl);
            this.mongoClient = new MongoClient(connectionString);
            this.mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logsCollection = this.mongoDatabase.getCollection(this.collectionName, BasicDBObject.class);
        }
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.putIfAbsent("time", this._sdf.format(new Date()));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        logMap.putIfAbsent("app", this.getApp());
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.error("UnknownHostException:" + e.getLocalizedMessage());
        }
        String ip = addr.getHostAddress().toString();
        String hostName = addr.getHostName().toString();
        logMap.putIfAbsent("source", hostName == null || hostName == "" ? ip : hostName);
        Message message = event.getMessage();
        if (message instanceof ObjectMessage) {
            Object parameter = ((ObjectMessage)message).getParameter();
            if (parameter instanceof Map) {
                logMap.putIfAbsent("message", parameter);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.putIfAbsent("defaultMessage", parameter.toString());
                logMap.putIfAbsent("message", map);
            }
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.putIfAbsent("defaultMessage", message.getFormattedMessage());
            logMap.putIfAbsent("message", map);
        }
        BasicDBObject document = new BasicDBObject();
        document.putAll(logMap);
        this.logsCollection.insertOne((Object)document);
    }

    @PluginFactory
    public static DwLogMongoAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="collectionName") String collectionName, @PluginAttribute(value="server") String server, @PluginAttribute(value="port") String port, @PluginAttribute(value="userName") String userName, @PluginAttribute(value="password") String password) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (databaseName == null) {
            LOGGER.error("no databaseName defined in conf.");
            return null;
        }
        if (collectionName == null) {
            LOGGER.error("no databaseName defined in conf.");
            return null;
        }
        if (server == null) {
            server = "127.0.0.1";
        }
        if (port == null) {
            port = "27017";
        }
        return new DwLogMongoAppender(name, filter, (Layout<? extends Serializable>)layout, databaseName, collectionName, server, port, userName, password);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }
}

