/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;

@Plugin(name="DwMongoDBAppender", category="Core", elementType="appender", printObject=true)
public class DwMongoDBAppender
extends AbstractAppender {
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoCollection<BasicDBObject> logsCollection;
    private String connectionUrl;
    private String userName;
    private String password;
    private String databaseName;
    private String collectionName;

    protected DwMongoDBAppender(String name, Filter filter, Layout<? extends Serializable> layout, String databaseName, String collectionName, String server, String port, String userName, String password) {
        super(name, filter, layout);
        if (userName == null || userName == "") {
            this.setConnectionUrl("mongodb://" + server + ":" + port);
        } else {
            this.setConnectionUrl("mongodb://" + userName + ":" + password + "@" + server + ":" + port);
        }
        this.setDatabaseName(databaseName);
        this.setCollectionName(collectionName);
    }

    public void append(LogEvent loggingEvent) {
        Message message;
        if (this.mongoDatabase == null) {
            MongoClientURI connectionString = new MongoClientURI(this.connectionUrl);
            this.mongoClient = new MongoClient(connectionString);
            this.mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
            this.logsCollection = this.mongoDatabase.getCollection(this.collectionName, BasicDBObject.class);
        }
        if ((message = loggingEvent.getMessage()) instanceof ObjectMessage) {
            Object parameter = ((ObjectMessage)message).getParameter();
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                BasicDBObject document = new BasicDBObject();
                document.put((Object)"level", (Object)loggingEvent.getLevel().toString());
                document.putAll(map);
                this.logsCollection.insertOne((Object)document);
            }
        } else if (message instanceof SimpleMessage) {
            BasicDBObject document = new BasicDBObject();
            document.put((Object)"defaultMessage", (Object)message.getFormattedMessage());
            this.logsCollection.insertOne((Object)document);
        } else {
            throw new IllegalArgumentException(message.getClass().getName());
        }
    }

    @PluginFactory
    public static DwMongoDBAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="collectionName") String collectionName, @PluginAttribute(value="server") String server, @PluginAttribute(value="port") String port, @PluginAttribute(value="userName") String userName, @PluginAttribute(value="password") String password) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (databaseName == null) {
            LOGGER.error("no databaseName defined in conf.");
            return null;
        }
        if (collectionName == null) {
            LOGGER.error("no databaseName defined in conf.");
            return null;
        }
        return new DwMongoDBAppender(name, filter, (Layout<? extends Serializable>)layout, databaseName, collectionName, server, port, userName, password);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

