/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.config;

import com.digiwin.app.log.ConfigurationUpdater;
import com.digiwin.app.log.DWLoggerContext;
import com.digiwin.app.log.DWLoggerContextFactory;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.bson.Document;
import org.bson.conversions.Bson;

public class StorageFacotry {
    private static MongoClient logsMongoClient;
    private static MongoDatabase logsMongoDatabase;
    private static MongoCollection<BasicDBObject> logsCollection;
    private MongoClient tracesMongoClient;
    private MongoDatabase tracesMongoDatabase;
    private MongoCollection<BasicDBObject> tracesCollection;

    public static void initLogsMongoDB() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (logsMongoDatabase == null) {
            Appender mongoAppender;
            Class<?> clazz = Class.forName("com.digiwin.app.log.appender.DwMongoDBAppender");
            Method getConnMethod = clazz.getMethod("getConnectionUrl", new Class[0]);
            Method getDBNameMethod = clazz.getMethod("getDatabaseName", new Class[0]);
            Method getColNameMethod = clazz.getMethod("getCollectionName", new Class[0]);
            if (DWLoggerContextFactory.isSettingDone()) {
                Logger logger = DWLoggerContext.getContext().getLogger(ConfigurationUpdater.class.getName());
                Configuration config = logger.getContext().getConfiguration();
                mongoAppender = (Appender)config.getAppenders().get("logServiceLogAppender");
            } else {
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = ctx.getConfiguration();
                mongoAppender = config.getAppender("logServiceLogAppender");
            }
            String connectionUrl = (String)getConnMethod.invoke((Object)mongoAppender, new Object[0]);
            String dbName = (String)getDBNameMethod.invoke((Object)mongoAppender, new Object[0]);
            String colName = (String)getColNameMethod.invoke((Object)mongoAppender, new Object[0]);
            MongoClientURI connectionString = new MongoClientURI(connectionUrl);
            logsMongoClient = new MongoClient(connectionString);
            logsMongoDatabase = logsMongoClient.getDatabase(dbName);
            logsCollection = logsMongoDatabase.getCollection(colName, BasicDBObject.class);
            StorageFacotry.initLogIndex();
        }
    }

    private static void initLogIndex() {
        int indexCount = 0;
        for (Document index : logsCollection.listIndexes()) {
            ++indexCount;
        }
        if (indexCount <= 1) {
            HashMap<String, Integer> indexMap1 = new HashMap<String, Integer>();
            indexMap1.putIfAbsent("appId", 1);
            indexMap1.putIfAbsent("time", -1);
            logsCollection.createIndex((Bson)new Document(indexMap1));
        }
    }
}

