/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DWLogThreadFactory
implements ThreadFactory {
    public static final String DEFAULT_THREAD_NAME_PREFIX = "DWLogOperation-";
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private final String threadPrefix;
    private final boolean daemon;

    public DWLogThreadFactory() {
        this("DWLogOperation", false);
    }

    public DWLogThreadFactory(String threadPrefix, boolean daemon) {
        this.threadPrefix = threadPrefix;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable rb) {
        String newThreadName = this.createThreadName();
        Thread thread = new Thread(rb, newThreadName);
        if (this.daemon) {
            thread.setDaemon(true);
        }
        return thread;
    }

    private String createThreadName() {
        StringBuilder buffer = new StringBuilder(this.threadPrefix.length() + 8);
        buffer.append(this.threadPrefix);
        buffer.append(this.threadNumber.getAndIncrement());
        buffer.append(')');
        return buffer.toString();
    }
}

