/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWorker;
import com.digiwin.app.log.operation.concurrent.DWLogThreadFactory;
import com.digiwin.app.log.operation.config.DWLogOperationThreadProperties;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DWLogOperationWriter
implements InitializingBean,
DisposableBean {
    private final Log log = LogFactory.getLog(this.getClass());
    boolean isDebug = this.log.isDebugEnabled();
    private static final int DESTROY_TIMEOUT = 3000;
    private ExecutorService executor;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private DWLogOperationThreadProperties threadProperties;
    private DWDao daoLogOperation;

    public void afterPropertiesSet() {
        DWLogThreadFactory threadFactory = new DWLogThreadFactory("DWLogOperationWriter-", true);
        this.executor = new ThreadPoolExecutor(this.threadProperties.getCorePoolSize(), this.threadProperties.getMaximumPoolSize(), this.threadProperties.getKeepAliveTime(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.threadProperties.getWorkQueueSize()), threadFactory);
    }

    public void doWrite(Object logOperationVoCollection, DWLogOperationContext logOperationContext) {
        Objects.requireNonNull(logOperationVoCollection, "logOperationVoCollection is required");
        if (this.daoLogOperation != null) {
            try {
                DWLogOperationContext workerLogOperationContext = logOperationContext.clone();
                DWLogOperationWorker job = new DWLogOperationWorker((DWLogOperationCollection)logOperationVoCollection, workerLogOperationContext);
                job.setDbDao(this.daoLogOperation);
                this.executor.execute(job);
                if (this.isDebug) {
                    this.log.debug((Object)String.format("[%s] job submitted ", this.getClass().getSimpleName()));
                }
            }
            catch (Exception e) {
                this.log.info((Object)String.format("[%s] exception:", e.getCause()));
                e.printStackTrace();
            }
        } else {
            this.log.info((Object)String.format("[%s] dao is null", this.getClass().getSimpleName()));
        }
    }

    public void destroy() throws Exception {
        StopWatch stopWatch = StopWatch.createStarted();
        if (this.isClose.compareAndSet(false, true)) {
            this.log.info((Object)"DWLogOperationWriter.destroy()");
            ExecutorService executor = this.executor;
            if (executor != null) {
                executor.shutdown();
                try {
                    executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            stopWatch.stop();
            long l = Math.max(3000L - stopWatch.getTime(), 100L);
        }
    }

    public DWDao getDaoLogOperation() {
        return this.daoLogOperation;
    }

    public void setDaoLogOperation(DWDao daoLogOperation) {
        this.daoLogOperation = daoLogOperation;
    }

    public DWLogOperationThreadProperties getThreadProperties() {
        return this.threadProperties;
    }

    public void setThreadProperties(DWLogOperationThreadProperties threadProperties) {
        this.threadProperties = threadProperties;
    }
}

