/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import com.digiwin.app.log.operation.vo.DWLogOperationSqlVo;
import com.digiwin.app.log.operation.vo.IDWLogOperationVo;
import com.digiwin.app.service.DWServiceContext;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class DWLogOperationWorker
implements Runnable {
    private final Log log = LogFactory.getLog(this.getClass());
    boolean isDebug = this.log.isDebugEnabled();
    private static ThreadLocal<DWLogOperationContext> _currentContext = new ThreadLocal();
    private DWDao dbDao;
    private String traceId;
    private final DWLogOperationContext logOperationContext;
    private final DWLogOperationCollection logOperationVoCollection;

    public DWLogOperationWorker(DWLogOperationCollection logOperationVoCollection, DWLogOperationContext logOperationContext) {
        this.logOperationVoCollection = logOperationVoCollection;
        this.logOperationContext = logOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StopWatch stopWatch = StopWatch.createStarted();
        this.traceId = this.logOperationContext.getTraceId();
        ThreadContext.put((String)"traceId", (String)this.traceId);
        String currentThreadName = Thread.currentThread().getName();
        if (this.isDebug) {
            this.log.debug((Object)String.format("[DWLogOperationWorker] thread:%s, starting...(traceId:%s))", currentThreadName, this.traceId));
        }
        DWServiceContext.getContext().setProfile(this.logOperationContext.getServiceProfile());
        _currentContext.set(this.logOperationContext);
        try {
            DWDataSetOperationOption daoOptions = new DWDataSetOperationOption();
            daoOptions.set(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED, (Object)false);
            daoOptions.setManagementFieldEnabled(false);
            DWDataSet dataSet = this.generateDataSet(this.logOperationVoCollection);
            this.dbDao.execute(dataSet, daoOptions);
        }
        catch (Exception e) {
            try {
                this.log.info((Object)String.format("[DWLogOperationWorker] thread:%s, exception:%s (traceId:%s)", currentThreadName, e.getCause(), this.traceId));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                if (this.isDebug) {
                    this.log.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
                }
                throw throwable;
            }
            stopWatch.stop();
            if (this.isDebug) {
                this.log.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
            }
        }
        stopWatch.stop();
        if (this.isDebug) {
            this.log.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
        }
    }

    private DWDataSet generateDataSet(Object data) {
        DWDataSet dataSet = new DWDataSet();
        if (data instanceof DWLogOperationCollection) {
            for (IDWLogOperationVo voRow : ((DWLogOperationCollection)data).getVoList()) {
                this.process(dataSet, voRow);
            }
        } else if (data instanceof IDWLogOperationVo) {
            this.process(dataSet, (IDWLogOperationVo)data);
        }
        return dataSet;
    }

    private void process(DWDataSet dataSet, IDWLogOperationVo opertVo) {
        if (opertVo instanceof DWLogOperationSqlVo) {
            DWLogOperationSqlVo sqlVo = (DWLogOperationSqlVo)opertVo;
            List dataList = (List)sqlVo.getData();
            dataSet.newTable(sqlVo.getTargetTableName()).newRows(dataList);
        } else {
            dataSet.newTable(opertVo.getTargetTableName()).newRow((Map)opertVo.getData());
        }
    }

    public DWDao getDbDao() {
        return this.dbDao;
    }

    public void setDbDao(DWDao dbDao) {
        this.dbDao = dbDao;
    }

    public static DWLogOperationContext getContext() {
        DWLogOperationContext context = _currentContext.get();
        return context;
    }
}

