/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.spring;

import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.common.config.remote.listener.DWConfigFileChangeListener;
import com.digiwin.app.common.config.remote.listener.ListenerRegister;
import com.digiwin.app.log.ConfigurationUpdater;
import com.digiwin.app.log.DWLoggerContext;
import com.digiwin.app.log.DWLoggerContextFactory;
import com.digiwin.app.log.Log4j2FileChangeListener;
import com.digiwin.app.log.LogFactoryImplement;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.springframework.boot.logging.LoggingSystem;

public class DWLog4J2LoggingSystem
extends LoggingSystem {
    private Log log;

    public DWLog4J2LoggingSystem(ClassLoader classLoader) {
    }

    public void beforeInitialize() {
        try {
            this.initLog4j();
            this.log.info((Object)("LogFactory implement: " + LogFactoryImplement.getLogFactoryimplementName()));
            this.log.info((Object)("Log implement: " + this.log.getClass().getSimpleName()));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLog4j() throws Exception {
        System.setProperty("Log4jLogEventFactory", "com.digiwin.app.log.DWLogEventFactory");
        System.setProperty("org.apache.commons.logging.Log", "com.digiwin.app.log.DWExtendedLogger");
        Class<LogFactory> clazz = LogFactory.class;
        synchronized (LogFactory.class) {
            ConfigPool pool = ConfigPool.getInstance();
            String xml = pool.getLog4j2Xml();
            DWLoggerContext.initLog4j2Xml(xml);
            DWLoggerContext dwContext = new DWLoggerContext("DWLoggerContext");
            DWLoggerContextFactory factory = new DWLoggerContextFactory(dwContext);
            LogManager.setFactory((LoggerContextFactory)factory);
            if (LogFactoryImplement.getLogFactoryimplement().equals((Object)LogFactoryImplement.Implement.SPRING_JCL)) {
                Class<?> log4jLogClass = Class.forName("org.apache.commons.logging.LogFactory$Log4jLog");
                Field loggerContextField = log4jLogClass.getDeclaredField("loggerContext");
                loggerContextField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(loggerContextField, loggerContextField.getModifiers() & 0xFFFFFFEF);
                loggerContextField.set(null, (Object)dwContext);
            }
            ConfigurationUpdater.execute(xml);
            this.log = LogFactory.getLog(DWLog4J2LoggingSystem.class);
            boolean isHookRemote = true;
            try {
                ListenerRegister.addLog4j2XmlChangeListener((DWConfigFileChangeListener)new Log4j2FileChangeListener());
            }
            catch (Exception e) {
                isHookRemote = false;
            }
            this.log.info((Object)("is hook remote log4j2.xml: " + isHookRemote));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

