/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.log.DWLoggerContext;
import com.digiwin.app.log.DWLoggerContextFactory;
import com.digiwin.app.log.LogFactoryImplement;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.selector.ContextSelector;

public class ConfigurationUpdater {
    private static final String DEFAULT_LOG_FILE_RESERVED_DAY = "7d";
    private static final String DEFAULT_LOG_LEVEL = "INFO";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String configurationSourceString) throws Exception {
        Class<LogManager> clazz = LogManager.class;
        synchronized (LogManager.class) {
            boolean isLogFileReservedDayWarn = false;
            boolean isLogLevelWarn = false;
            if (configurationSourceString.contains("@logFileReservedDay@")) {
                isLogFileReservedDayWarn = true;
                configurationSourceString = configurationSourceString.replace("@logFileReservedDay@", DEFAULT_LOG_FILE_RESERVED_DAY);
            }
            if (configurationSourceString.contains("@logLevel@")) {
                isLogLevelWarn = true;
                configurationSourceString = configurationSourceString.replace("@logLevel@", DEFAULT_LOG_LEVEL);
            }
            byte[] byteArray = configurationSourceString.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ConfigurationSource configurationSource = new ConfigurationSource((InputStream)bufferedInputStream);
            DWLoggerContextFactory factory = (DWLoggerContextFactory)LogManager.getFactory();
            ContextSelector selector = factory.getSelector();
            LoggerContext ctx = selector.getContext(LogManager.class.getName(), null, false, null);
            if (ctx.getState() != LifeCycle.State.INITIALIZED) {
                LogManager.shutdown();
            }
            if (LogFactoryImplement.getLogFactoryimplement().equals((Object)LogFactoryImplement.Implement.APACHE_COMMONS_LOGGING)) {
                LogFactory.releaseAll();
                LogFactory.getFactory().setAttribute("org.apache.commons.logging.log", (Object)"com.digiwin.app.log.DWExtendedLogger");
            }
            Configurator.initialize(null, (ConfigurationSource)configurationSource);
            DWLoggerContextFactory.setSettingDone(true);
            Logger logger = DWLoggerContext.getContext().getLogger(ConfigurationUpdater.class.getName());
            Log log = LogFactory.getLog(ConfigurationUpdater.class);
            log.info((Object)("log level: " + logger.getLevel()));
            if (isLogFileReservedDayWarn) {
                log.warn((Object)"using default logFileReservedDay (7d), please check config center or platform/conf/log4j2.xml");
            }
            if (isLogLevelWarn) {
                log.warn((Object)"using default logLevel (INFO), please check config center or platform/conf/log4j2.xml");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

