/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.appender;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="DwMongoDBAppender", category="Core", elementType="appender", printObject=true)
public class DwMongoDBAppender
extends AbstractAppender {
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private MongoDatabase mongoDatabase;
    private MongoCollection<BasicDBObject> logsCollection;
    private List<String> tracerKeysList;
    private String connectionUrl;
    private String userName;
    private String password;
    private String databaseName;
    private String collectionName;
    private String app;
    private String traceKeys;

    protected DwMongoDBAppender(String name, Filter filter, Layout<? extends Serializable> layout, String databaseName, String collectionName, String server, String port, String userName, String password, String traceKeys) {
        super(name, filter, layout);
        if (userName == null || userName == "") {
            this.setConnectionUrl("mongodb://" + server + ":" + port);
        } else {
            this.setConnectionUrl("mongodb://" + userName + ":" + password + "@" + server + ":" + port);
        }
        this.setDatabaseName(databaseName);
        this.setCollectionName(collectionName);
        this.setTraceKeys(traceKeys);
        String app = DWApplicationConfigUtils.getProperty((String)"appId");
        this.setApp(app);
    }

    public void append(LogEvent loggingEvent) {
    }

    @PluginFactory
    public static DwMongoDBAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="collectionName") String collectionName, @PluginAttribute(value="server") String server, @PluginAttribute(value="port") String port, @PluginAttribute(value="userName") String userName, @PluginAttribute(value="password") String password, @PluginAttribute(value="traceKeys") String traceKeys) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (databaseName == null) {
            LOGGER.error("no databaseName defined in conf.");
            return null;
        }
        if (collectionName == null) {
            LOGGER.error("no databaseName defined in conf.");
            return null;
        }
        return new DwMongoDBAppender(name, filter, (Layout<? extends Serializable>)layout, databaseName, collectionName, server, port, userName, password, traceKeys);
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getTraceKeys() {
        return this.traceKeys;
    }

    public void setTraceKeys(String traceKeys) {
        if (StringUtils.isNotBlank((CharSequence)traceKeys)) {
            this.traceKeys = traceKeys;
            this.tracerKeysList = Stream.of(traceKeys.split(",")).map(String::trim).collect(Collectors.toList());
        }
    }
}

