/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.loader;

import com.digiwin.app.metadata.exceptions.DWMetadataException;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.loader.DWMetadataLoader;
import com.digiwin.app.metadata.loader.DWMetadataLoaderManager;
import com.digiwin.app.metadata.ui.DWUIField;
import com.digiwin.app.metadata.ui.DWUIMetadata;
import com.digiwin.app.metadata.ui.DWUIMetadataUtils;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;

public class DWUIMetadataLoader
extends DWMetadataLoader<DWUIMetadata> {
    public DWUIMetadataLoader() {
        DWMetadataLoaderManager.registerLoader(this);
    }

    private static List<Map<String, Object>> select(String statement, Object ... params) throws DWMetadataException {
        List result;
        QueryRunner queryRunner = (QueryRunner)SpringContextUtils.getBean((String)"dw-queryRunner");
        try {
            result = (List)queryRunner.query(statement, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (Exception e) {
            throw new DWMetadataException("load failed!", e);
        }
        return result;
    }

    private static List<Map<String, Object>> getUIMetadataTable(String programNo) {
        String sql = "SELECT operation_id,table_name,field_id,length,nullable,format,enum,resource FROM dw_ui_metadata WHERE 1=1 AND operation_id=? ";
        return DWUIMetadataLoader.select(sql, programNo);
    }

    @Override
    public DWUIMetadata load(String name) {
        List<Map<String, Object>> uiTable = null;
        if (null == DWUIMetadataLoader.getUIMetadataTable(name) || DWUIMetadataLoader.getUIMetadataTable(name).isEmpty()) {
            throw new DWMetadataNotFoundException(name);
        }
        uiTable = DWUIMetadataLoader.getUIMetadataTable(name);
        DWUIField[] uiFiled = DWUIMetadataLoader.generateDWUIField(uiTable);
        DWUIMetadata uiMetadata = DWUIMetadataUtils.createMetadata(name);
        for (int i = 0; i < uiFiled.length; ++i) {
            uiMetadata.addField(uiFiled[i]);
        }
        return uiMetadata;
    }

    public static DWUIField[] generateDWUIField(List<Map<String, Object>> uiTable) {
        DWUIField[] uiFiled = new DWUIField[uiTable.size()];
        int index = 0;
        for (Map<String, Object> map : uiTable) {
            uiFiled[index] = DWUIMetadataUtils.createUIField(map.get("operation_id").toString(), map.get("field_id").toString(), map.get("table_name").toString(), null != map.get("length") ? Integer.valueOf(map.get("length").toString()) : null, null == map.get("nullable") || !map.get("nullable").toString().equals("N"), null != map.get("format") ? map.get("format").toString() : null, null != map.get("enum") ? map.get("enum").toString() : null, null != map.get("resource") ? map.get("resource").toString() : null);
            ++index;
        }
        return uiFiled;
    }
}

