/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.rdbms;

import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsOneToManyField;

public final class DWRdbmsUtils {
    public static DWRdbmsMetadata createMetadata(String name) {
        DWRdbmsMetadata metadata = new DWRdbmsMetadata(name);
        return metadata;
    }

    public static DWRdbmsMetadata createMetadata(String name, DWRdbmsField ... fields) {
        DWRdbmsMetadata metadata = new DWRdbmsMetadata(name);
        for (DWRdbmsField field : fields) {
            metadata.addField(field);
        }
        return metadata;
    }

    public static DWRdbmsField createStringField(String name, int size) {
        return new DWRdbmsField(name, "STRING", size, 0);
    }

    public static DWRdbmsField createStringField(String name, int size, boolean nullable) {
        return new DWRdbmsField(name, "STRING", size, 0, nullable);
    }

    public static DWRdbmsField createStringField(String name, int size, boolean nullable, boolean primaryKey) {
        return new DWRdbmsField(name, "STRING", size, 0, nullable, primaryKey);
    }

    public static DWRdbmsField createIntegerField(String name, int size) {
        return new DWRdbmsField(name, "INT", size, 0);
    }

    public static DWRdbmsField createIntegerField(String name, int size, boolean nullable, boolean primaryKey) {
        return DWRdbmsUtils.createIntegerField(name, size, nullable, primaryKey, false);
    }

    public static DWRdbmsField createIntegerField(String name, int size, boolean nullable, boolean primaryKey, boolean versionControll) {
        return new DWRdbmsField(name, "INT", size, 0, nullable, primaryKey, versionControll);
    }

    public static DWRdbmsField createDecimalField(String name, int size, boolean nullable, int scale) {
        return new DWRdbmsField(name, "DECIMAL", size, scale, nullable);
    }

    public static DWRdbmsField createDateField(String name) {
        return new DWRdbmsField(name, "DATE");
    }

    public static DWRdbmsField createDateField(String name, boolean nullable) {
        return new DWRdbmsField(name, "DATE", nullable);
    }

    public static DWRdbmsField createDateField(String name, boolean nullable, boolean primaryKey) {
        return new DWRdbmsField(name, "DATE", nullable, primaryKey);
    }

    public static DWRdbmsField createDatetimeField(String name) {
        return new DWRdbmsField(name, "DATETIME");
    }

    public static DWRdbmsField createDatetimeField(String name, boolean nullable) {
        return new DWRdbmsField(name, "DATETIME", nullable);
    }

    public static DWRdbmsField createDatetimeField(String name, boolean nullable, boolean primaryKey) {
        return new DWRdbmsField(name, "DATETIME", nullable, primaryKey);
    }

    public static DWRdbmsField createBooleanField(String name) {
        return new DWRdbmsField(name, "BOOLEAN");
    }

    @Deprecated
    public static DWRdbmsOneToManyField createOneToManyField(String detailTableName) {
        return new DWRdbmsOneToManyField(detailTableName, detailTableName);
    }

    @Deprecated
    public static DWRdbmsOneToManyField createOneToManyField(String name, String detailTableName) {
        return new DWRdbmsOneToManyField(name, detailTableName);
    }
}

