/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.rdbms;

import com.digiwin.app.metadata.DWField;
import com.digiwin.app.metadata.DWNamedAttribute;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.metadata.rdbms.DWRdbmsFieldValueType;

public class DWRdbmsField
extends DWField {
    public DWRdbmsField() {
    }

    public DWRdbmsField(String name, String valueType, String defaultValue) {
        this(name, valueType, 0, 0, defaultValue);
    }

    public DWRdbmsField(String name, String valueType, int size, int scale, String defaultValue) {
        this(name, valueType, size, scale, false, defaultValue);
    }

    public DWRdbmsField(String name, String valueType, boolean nullable, String defaultValue) {
        this(name, valueType, 0, 0, nullable, defaultValue);
    }

    public DWRdbmsField(String name, String valueType, boolean nullable, boolean primaryKey, String defaultValue) {
        this(name, valueType, 0, 0, nullable, primaryKey, defaultValue);
    }

    public DWRdbmsField(String name, String valueType, int size, int scale, boolean nullable, String defaultValue) {
        this(name, valueType, size, scale, nullable, false, defaultValue);
    }

    public DWRdbmsField(String name, String valueType, int size, int scale, boolean nullable, boolean primaryKey, String defaultValue) {
        this(name, valueType, size, scale, nullable, primaryKey, false, defaultValue);
    }

    public DWRdbmsField(String name, String valueType, int size, int scale, boolean nullable, boolean primaryKey, boolean versionControll, String defaultValue) {
        super(name);
        this.addAttribute(DWValueAttribute.create(valueType, DWRdbmsAttributes.RDBMS_VALUE_TYPE));
        this.addAttribute(DWValueAttribute.create(size, DWRdbmsAttributes.RDBMS_SIZE));
        this.addAttribute(DWValueAttribute.create(scale, DWRdbmsAttributes.RDBMS_SCALE));
        this.addAttribute(DWValueAttribute.create(nullable, DWRdbmsAttributes.RDBMS_NULLABLE));
        this.addAttribute(DWValueAttribute.create(primaryKey, DWRdbmsAttributes.RDBMS_PRIMARY_KEY));
        this.addAttribute(DWValueAttribute.create(defaultValue, DWRdbmsAttributes.RDBMS_DEFAULT_VALUE));
        if (versionControll) {
            this.setVersionControl();
        }
    }

    public String getValueType() {
        DWValueAttribute valueTypeAttr = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE);
        return (String)valueTypeAttr.getValue();
    }

    public int getSize() {
        DWValueAttribute sizeAttr = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_SIZE);
        return (Integer)sizeAttr.getValue();
    }

    public int getScale() {
        DWValueAttribute scaleAttr = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_SCALE);
        return (Integer)scaleAttr.getValue();
    }

    public boolean isNullable() {
        DWValueAttribute nullableAttr = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_NULLABLE);
        return (Boolean)nullableAttr.getValue();
    }

    public boolean isPrimaryKey() {
        DWValueAttribute primaryKeyAttr = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_PRIMARY_KEY);
        return (Boolean)primaryKeyAttr.getValue();
    }

    public String getDefaultValue() {
        DWValueAttribute valueTypeAttr = (DWValueAttribute)this.getAttribute(DWRdbmsAttributes.RDBMS_DEFAULT_VALUE);
        return (String)valueTypeAttr.getValue();
    }

    public void setVersionControl() {
        this.addAttribute(new DWNamedAttribute(DWRdbmsAttributes.RDBMS_VERSION_CONTROL));
    }

    public void setAutoIncrement() {
        this.addAttribute(new DWNamedAttribute(DWRdbmsAttributes.RDBMS_AUTO_INCREMENT));
    }

    public boolean isNumericType() {
        return DWRdbmsFieldValueType.isNumericType(this);
    }
}

