/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.boot.actuate.health.HealthIndicator;

public abstract class DWAbstractModuleBeanHealthIndicatorProcessor<H extends HealthIndicator, S> {
    private Class<H> indicatorType;
    private Class<S> targetBeanType;

    public DWAbstractModuleBeanHealthIndicatorProcessor() {
        Type[] parameterizedType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.indicatorType = (Class)parameterizedType[0];
        this.targetBeanType = (Class)parameterizedType[1];
    }

    public boolean accept(Object bean) {
        if (bean == null) {
            return false;
        }
        return this.targetBeanType.isAssignableFrom(bean.getClass());
    }

    public Class<?> getTargetBeanType() {
        return this.targetBeanType;
    }

    protected abstract String getIndicatorName();

    public H createHealthIndicator(S bean) {
        try {
            return (H)((HealthIndicator)this.indicatorType.getConstructor(this.targetBeanType).newInstance(bean));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create indicator " + this.indicatorType + " for source " + this.targetBeanType, ex);
        }
    }
}

