/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.redis;

import com.digiwin.app.metadata.redis.AbstractRedisPoolMetadata;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;

public class LettuceConnectionFactoryPoolMetadata
extends AbstractRedisPoolMetadata<LettuceConnectionFactory> {
    private static final String PROVIDER = "connectionProvider";
    private static final String REACTIVE_PROVIDER = "reactiveConnectionProvider";

    public LettuceConnectionFactoryPoolMetadata(LettuceConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
    }

    @Override
    public Integer getcurrent() {
        GenericObjectPool genericObjectPool = this.getPool();
        if (Objects.nonNull(genericObjectPool)) {
            return genericObjectPool.listAllObjects().size();
        }
        return null;
    }

    @Override
    public Integer getMax() {
        GenericObjectPool genericObjectPool = this.getPool();
        if (Objects.nonNull(genericObjectPool)) {
            return genericObjectPool.getMaxTotal();
        }
        return null;
    }

    @Override
    public Integer getMin() {
        GenericObjectPool genericObjectPool = this.getPool();
        if (Objects.nonNull(genericObjectPool)) {
            return genericObjectPool.getMinIdle();
        }
        return null;
    }

    LettuceConnectionProvider getProviderByName(String prodiverName) {
        LettuceConnectionFactory redisConnectionFactory = (LettuceConnectionFactory)this.getRedisConnectionFactory();
        Object connectionProvider = new DirectFieldAccessor((Object)redisConnectionFactory).getPropertyValue(prodiverName);
        return (LettuceConnectionProvider)connectionProvider;
    }

    GenericObjectPool getPool() {
        Object poolSupport;
        LettuceConnectionProvider lettuceConnectionProvider = this.getProviderByName(PROVIDER);
        Object pools = null;
        pools = this.getPoolFromConnectionProvider(lettuceConnectionProvider);
        if (Objects.nonNull(pools) && pools instanceof Map && ((Map)pools).size() > 0 && (poolSupport = ((Map)pools).values().toArray()[0]) instanceof GenericObjectPool) {
            return (GenericObjectPool)poolSupport;
        }
        lettuceConnectionProvider = this.getProviderByName(REACTIVE_PROVIDER);
        pools = this.getPoolFromConnectionProvider(lettuceConnectionProvider);
        if (Objects.nonNull(pools) && pools instanceof Map && ((Map)pools).size() > 0 && (poolSupport = ((Map)pools).values().toArray()[0]) instanceof GenericObjectPool) {
            return (GenericObjectPool)poolSupport;
        }
        return null;
    }

    Object getPoolFromConnectionProvider(LettuceConnectionProvider lettuceConnectionProvider) {
        Object pools = null;
        if (Objects.nonNull(lettuceConnectionProvider)) {
            pools = new DirectFieldAccessor((Object)lettuceConnectionProvider).getPropertyValue("pools");
        }
        return pools;
    }
}

