/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.thread;

import com.digiwin.app.thread.DWThreadMBean;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import io.micrometer.core.instrument.search.RequiredSearch;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.OptionalLong;

public class DWThreadInfo {
    MeterRegistry registry;
    DWThreadMBean dwthreadMBean;
    private static final String THREAD_TIME_METER = "dwThread.time";
    private static final String THREAD_ID = "thread.id";
    private static final String THREAD_NAME = "thread.name";
    private static final String THREAD_STATE = "thread.state";

    public DWThreadInfo(MeterRegistry registry) {
        this.registry = registry;
        this.dwthreadMBean = new DWThreadMBean();
        Gauge.builder((String)THREAD_TIME_METER, (Object)this.dwthreadMBean, s -> {
            long[] allThreadIds = this.dwthreadMBean.getThreadMXBean().getAllThreadIds();
            this.removeDieThread(allThreadIds);
            for (long threadId : allThreadIds) {
                RequiredSearch threadSearchResult = registry.get(THREAD_TIME_METER).tag(THREAD_ID, String.valueOf(threadId));
                try {
                    threadSearchResult.gauge();
                }
                catch (MeterNotFoundException e) {
                    ThreadInfo threadInfo = this.dwthreadMBean.getThreadMXBean().getThreadInfo(threadId);
                    Gauge.builder((String)THREAD_TIME_METER, (Object)this.dwthreadMBean, dwthreadMBean -> dwthreadMBean.getThreadMXBean().getThreadCpuTime(threadId)).tag(THREAD_ID, String.valueOf(threadId)).tag(THREAD_NAME, threadInfo.getThreadName()).tag(THREAD_STATE, threadInfo.getThreadState().name()).register(this.registry);
                }
            }
            return s.getPlatformMXBean().getProcessCpuTime();
        }).tag(THREAD_ID, "-1").tag(THREAD_NAME, "jvm_thread").tag(THREAD_STATE, Thread.State.RUNNABLE.name()).register(this.registry);
    }

    private void removeDieThread(long[] allThreadIds) {
        this.registry.forEachMeter(meter -> {
            OptionalLong anyMatch;
            String registedThreadId;
            Meter.Id meterId = meter.getId();
            if (meterId.getName().equals(THREAD_TIME_METER) && !"-1".equals(registedThreadId = meterId.getTag(THREAD_ID)) && !(anyMatch = Arrays.stream(allThreadIds).filter(currentId -> registedThreadId.equals(String.valueOf(currentId))).findAny()).isPresent()) {
                this.registry.remove(meter);
            }
        });
    }
}

