/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.actuate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.springframework.boot.actuate.health.HealthIndicator;

public abstract class DWAbstractModuleBeanHealthIndicatorProcessor<H extends HealthIndicator, S> {
    private Class<H> indicatorType;
    private Class<S> targetBeanType;
    private Function<S, H> indicatorFactory = null;

    public DWAbstractModuleBeanHealthIndicatorProcessor(Function<S, H> indicatorFactory) {
        this();
        this.indicatorFactory = indicatorFactory;
    }

    public DWAbstractModuleBeanHealthIndicatorProcessor() {
        Type[] parameterizedType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.indicatorType = (Class)parameterizedType[0];
        this.targetBeanType = (Class)parameterizedType[1];
    }

    public boolean accept(Object bean) {
        if (bean == null) {
            return false;
        }
        return this.targetBeanType.isAssignableFrom(bean.getClass());
    }

    public Class<?> getTargetBeanType() {
        return this.targetBeanType;
    }

    protected abstract String getIndicatorName();

    public H createHealthIndicator(S bean) {
        if (this.indicatorFactory != null) {
            return (H)((HealthIndicator)this.indicatorFactory.apply(bean));
        }
        try {
            return (H)((HealthIndicator)this.indicatorType.getConstructor(this.targetBeanType).newInstance(bean));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create indicator " + String.valueOf(this.indicatorType) + " for source " + String.valueOf(this.targetBeanType), ex);
        }
    }
}

