/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.datasource;

import com.digiwin.app.metadata.datasource.DWAbstractDataSourcePoolMetadata;
import java.util.Objects;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.DirectFieldAccessor;

public class Dbcp2DataSourcePoolMetadata
extends DWAbstractDataSourcePoolMetadata<BasicDataSource> {
    public Dbcp2DataSourcePoolMetadata(BasicDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Integer getPooling() {
        BasicDataSource basicDataSource = (BasicDataSource)this.getDataSource();
        GenericObjectPool connectionPool = (GenericObjectPool)new DirectFieldAccessor((Object)basicDataSource).getPropertyValue("connectionPool");
        if (Objects.isNull(connectionPool)) {
            return 0;
        }
        return connectionPool.listAllObjects().size();
    }

    public Integer getActive() {
        return ((BasicDataSource)this.getDataSource()).getNumActive();
    }

    public Integer getMax() {
        return ((BasicDataSource)this.getDataSource()).getMaxIdle();
    }

    public Integer getMin() {
        return ((BasicDataSource)this.getDataSource()).getMinIdle();
    }

    public String getValidationQuery() {
        return ((BasicDataSource)this.getDataSource()).getValidationQuery();
    }

    public Boolean getDefaultAutoCommit() {
        return ((BasicDataSource)this.getDataSource()).getDefaultAutoCommit();
    }
}

