/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigurer;

import com.digiwin.app.autoconfigure.UtilitiesAutoConfiguration;
import com.digiwin.app.autoconfigurer.DWModularApplicationLayerConfiguration;
import com.digiwin.app.autoconfigurer.DWModularModuleLayerConfiguration;
import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.resource.modular.spring.DWModuleConfigUtilsPropertySource;
import com.digiwin.resource.modular.spring.DWPropertySourceAppContextInitializer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.PropertySource;

@Configuration
@ConditionalOnClass(value={DWModuleSpringUtils.class})
@AutoConfigureBefore(value={UtilitiesAutoConfiguration.class})
public class DWModularPropertySourceAutoConfiguration {
    public static int DAP_PROPERTY_SOURCE_CONFIGURER_ORDER = -2000;

    public DWModularPropertySourceAutoConfiguration() {
        DWModuleSpringUtils.registerModuleConfigurationClass(DWModularModuleLayerConfiguration.class);
        DWModuleSpringUtils.registerModuleBeforeRefreshListener(DWModularPropertySourceAutoConfiguration::beforeModuleApplicationContextRefresh);
        DWApplicationSpringUtils.registerConfigurationClass(DWModularApplicationLayerConfiguration.class);
        DWApplicationSpringUtils.registerApplicationBeforeRefreshListener(DWPropertySourceAppContextInitializer::reOrderPropertySources);
    }

    protected static void beforeModuleApplicationContextRefresh(String moduleName, GenericXmlApplicationContext applicationContext) {
        DWPropertySourceAppContextInitializer.reOrderPropertySources((ConfigurableApplicationContext)applicationContext);
        applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)DWModuleConfigUtilsPropertySource.createInstance(moduleName));
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
        configurer.setOrder(DAP_PROPERTY_SOURCE_CONFIGURER_ORDER);
        configurer.setIgnoreUnresolvablePlaceholders(true);
        return configurer;
    }
}

