/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.resource.modular.spring;

import com.digiwin.resource.modular.spring.DWApplicationConfigUtilsPropertySource;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class DWPropertySourceAppContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static Log log = LogFactory.getLog(DWPropertySourceAppContextInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        log.info((Object)"DWPropertySourceAppContextInitializer.....");
        DWPropertySourceAppContextInitializer.reOrderPropertySources(applicationContext);
        applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)DWApplicationConfigUtilsPropertySource.createInstance());
    }

    public static void reOrderPropertySources(ConfigurableApplicationContext applicationContext) {
        String springbootConfigPropertiesName;
        ArrayList<Object> dapPropertySourceSequence = new ArrayList<Object>();
        MutablePropertySources rootPropertySources = applicationContext.getEnvironment().getPropertySources();
        if (rootPropertySources.contains("dap-application-propertysource")) {
            dapPropertySourceSequence.add(rootPropertySources.get("dap-application-propertysource"));
        }
        if (rootPropertySources.contains(springbootConfigPropertiesName = "configurationProperties")) {
            dapPropertySourceSequence.add(rootPropertySources.get(springbootConfigPropertiesName));
        }
        for (PropertySource ps : rootPropertySources) {
            if (!(ps instanceof OriginTrackedMapPropertySource)) continue;
            dapPropertySourceSequence.add((OriginTrackedMapPropertySource)ps);
        }
        if (rootPropertySources.contains("systemProperties")) {
            dapPropertySourceSequence.add(rootPropertySources.get("systemProperties"));
        }
        if (rootPropertySources.contains("systemEnvironment")) {
            dapPropertySourceSequence.add(rootPropertySources.get("systemEnvironment"));
        }
        for (int i = dapPropertySourceSequence.size() - 1; i >= 0; --i) {
            rootPropertySources.remove(((PropertySource)dapPropertySourceSequence.get(i)).getName());
            rootPropertySources.addFirst((PropertySource)dapPropertySourceSequence.get(i));
        }
    }
}

